package edu.uiuc.ncsa.myproxy.oa4mp.oauth2.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.MyProxyDelegationServlet;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.InvalidTokenException;
import edu.uiuc.ncsa.security.core.exceptions.TransactionNotFoundException;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.server.request.IssuerResponse;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.oauth_2_0.server.UII2;
import edu.uiuc.ncsa.security.oauth_2_0.server.UIIRequest2;
import edu.uiuc.ncsa.security.oauth_2_0.server.UIIResponse2;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

import static edu.uiuc.ncsa.security.core.util.DateUtils.checkTimestamp;

/**
 * <p>Created by Jeff Gaynor<br>
 * on 10/4/13 at  11:09 AM
 */
public class UserInfoServlet extends MyProxyDelegationServlet {
    @Override
    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        //  printAllParameters(request);
        // The access token is sent in the authorization header and should look like
        // Bearer oa4mp:...

        String rawToken = request.getHeader("authorization");
        AccessToken at = null;
        if (rawToken == null || 0 == rawToken.length()) {
            at = getServiceEnvironment().getTokenForge().getAccessToken(request);
        } else {
            rawToken = rawToken.substring(rawToken.indexOf(" ") + 1);
            at = getServiceEnvironment().getTokenForge().getAccessToken(rawToken);
        }
        if (at == null) {
            // the bearer token should be sent in the authorization header.
            throw new GeneralException("Error: no access token was sent.");
        }
        ServiceTransaction transaction = (ServiceTransaction) getTransactionStore().get(at);
        if (transaction == null) {
            throw new TransactionNotFoundException("error: The transaction with access token=" + at + " was not found.");
        }
        if (!transaction.isAccessTokenValid()) {
            throw new InvalidTokenException("Error: The access token is not valid.");
        }
        checkTimestamp(at.getToken());
        UII2 uis = new UII2(getServiceEnvironment().getTokenForge(), getServiceEnvironment().getServiceAddress());
        UIIRequest2 uireq = new UIIRequest2(request, at);
        uireq.setUsername(getUsername(transaction));
        UIIResponse2 uiresp = (UIIResponse2) uis.process(uireq);
        uiresp.write(response);
    }

    /**
     * Override this if needed.
     * @param transaction
     * @return
     */
    protected String getUsername(ServiceTransaction transaction) {
        return transaction.getUsername();
    }

    // not implemented.
    @Override
    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws IOException {
        return null;
    }
}
