/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.oauth2.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.OA2ServiceTransaction;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.AbstractAuthroizationServlet;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.servlet.JSPUtil;
import edu.uiuc.ncsa.security.servlet.PresentableState;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import net.sf.json.JSONObject;

public class OA2AuthorizationServer
extends AbstractAuthroizationServlet {
    public String AUTHORIZATION_REFRESH_TOKEN_LIFETIME_KEY = "AuthRTL";
    public String AUTHORIZED_ENDPOINT = "/authorized";
    public String AUTHORIZATION_REFRESH_TOKEN_LIFETIME_VALUE = "rtLifetime";

    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        Map map = this.getFirstParameters(request);
        if (map.containsKey("response_type")) {
            MyHttpServletResponseWrapper wrapper = new MyHttpServletResponseWrapper(response);
            JSPUtil.fwd((HttpServletRequest)request, (HttpServletResponse)wrapper, (String)this.AUTHORIZED_ENDPOINT);
            if (wrapper.isExceptionEncountered()) {
                return;
            }
            String content = wrapper.toString();
            JSONObject j = JSONObject.fromObject((Object)content);
            String code = j.get("code").toString();
            String state = j.get("state").toString();
            request.setAttribute("code", (Object)code);
            request.setAttribute("state", (Object)state);
        }
        super.doIt(request, response);
    }

    public void prepare(PresentableState state) throws Throwable {
        super.prepare(state);
        if (state.getState() == 0) {
            state.getRequest().setAttribute(this.AUTHORIZATION_REFRESH_TOKEN_LIFETIME_KEY, (Object)this.AUTHORIZATION_REFRESH_TOKEN_LIFETIME_KEY);
        }
        if (state.getState() == 1) {
            AbstractAuthroizationServlet.AuthorizedState authorizedState = (AbstractAuthroizationServlet.AuthorizedState)state;
            ((OA2ServiceTransaction)authorizedState.getTransaction()).setAuthTime(new Date());
        }
    }

    public void present(PresentableState state) throws Throwable {
        super.present(state);
    }

    protected void createRedirect(HttpServletRequest request, HttpServletResponse response, ServiceTransaction trans) throws Throwable {
        String rawrtl = request.getParameter(this.AUTHORIZATION_REFRESH_TOKEN_LIFETIME_KEY);
        OA2ServiceTransaction st2 = (OA2ServiceTransaction)trans;
        try {
            if (rawrtl != null) {
                st2.setRefreshTokenLifetime(Long.parseLong(rawrtl) * 1000L);
            }
        }
        catch (Throwable t) {
            st2.setRefreshTokenLifetime(0L);
        }
        super.createRedirect(request, response, trans);
    }

    public String createCallback(ServiceTransaction trans, Map<String, String> params) {
        String cb = trans.getCallback().toString();
        String idStr = trans.getIdentifierString();
        try {
            cb = cb + (cb.indexOf("?") == -1 ? "?" : "&") + "code" + "=" + URLEncoder.encode(idStr, "UTF-8");
            if (params.containsKey("state")) {
                cb = cb + "&" + "state" + "=" + URLEncoder.encode(params.get("state"), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return cb;
    }

    protected void doRealCertRequest(ServiceTransaction trans, String statusString) throws Throwable {
    }

    static class MyHttpServletResponseWrapper
    extends HttpServletResponseWrapper {
        private StringWriter sw = new StringWriter();
        boolean exceptionEncountered = false;

        public MyHttpServletResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public PrintWriter getWriter() throws IOException {
            return new PrintWriter(this.sw);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.sw.toString();
        }

        boolean isExceptionEncountered() {
            return this.exceptionEncountered;
        }

        void setExceptionEncountered(boolean exceptionEncountered) {
            this.exceptionEncountered = exceptionEncountered;
        }
    }
}

