/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.oauth2.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.OA2ServiceTransaction;
import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.servlet.OA2ClientCheck;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.AbstractInitServlet;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.server.request.AGResponse;
import edu.uiuc.ncsa.security.delegation.server.request.IssuerResponse;
import edu.uiuc.ncsa.security.oauth_2_0.NonceHerder;
import edu.uiuc.ncsa.security.oauth_2_0.OA2Error;
import edu.uiuc.ncsa.security.oauth_2_0.OA2Scopes;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OA2AuthorizedServlet
extends AbstractInitServlet {
    protected void doIt(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Throwable {
        String callback = httpServletRequest.getParameter("redirect_uri");
        if (httpServletRequest.getParameterMap().containsKey("request_uri")) {
            throw new OA2Error("request_uri_not_supported", "Request uri not supported by this server", httpServletRequest.getParameter("state"), callback);
        }
        if (httpServletRequest.getParameterMap().containsKey("request")) {
            throw new OA2Error("request_not_supported", "Request not supported by this server", httpServletRequest.getParameter("state"), callback);
        }
        if (!httpServletRequest.getParameterMap().containsKey("response_type")) {
            throw new OA2Error("invalid_request", "no response type", httpServletRequest.getParameter("state"), callback);
        }
        super.doIt(httpServletRequest, httpServletResponse);
    }

    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws UnsupportedEncodingException {
        String nonce;
        AGResponse agResponse = (AGResponse)iResponse;
        Map params = agResponse.getParameters();
        String state = null;
        if (params.containsKey("state")) {
            state = (String)params.get("state");
        }
        String givenRedirect = (String)params.get("redirect_uri");
        OA2ClientCheck.check(agResponse.getClient(), givenRedirect);
        String rawSecret = (String)params.get("client_secret");
        if (rawSecret != null) {
            this.info("Client is sending secret in initial request. Though not forbidden by the protocol this is discouraged.");
        }
        if ((nonce = (String)params.get("nonce")) == null || nonce.length() == 0) {
            this.info("No nonce in initial request for " + ((AGResponse)iResponse).getClient().getIdentifierString());
        } else {
            NonceHerder.checkNonce((String)nonce);
        }
        if (params.containsKey("display") && !((String)params.get("display")).equals("page")) {
            throw new OA2Error("invalid_request", "Only display=page is supported", state, givenRedirect);
        }
        String rawScopes = (String)params.get("scope");
        if (rawScopes == null || rawScopes.length() == 0) {
            throw new OA2Error("invalid_scope", "Missing scopes parameter.", state, givenRedirect);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(rawScopes);
        ArrayList<String> scopes = new ArrayList<String>();
        boolean hasOpenIDScope = false;
        while (stringTokenizer.hasMoreTokens()) {
            String x = stringTokenizer.nextToken();
            if (!OA2Scopes.ScopeUtil.hasScope((String)x)) {
                throw new OA2Error("invalid_scope", "Unrecognized scope", state, givenRedirect);
            }
            if (x.equals("openid")) {
                hasOpenIDScope = true;
            }
            scopes.add(x);
        }
        if (!hasOpenIDScope) {
            throw new OA2Error("invalid_request", "Scopes must contain openid", state, givenRedirect);
        }
        OA2ServiceTransaction st = new OA2ServiceTransaction(agResponse.getGrant());
        st.setScopes(scopes);
        st.setAuthGrantValid(false);
        st.setAccessTokenValid(false);
        st.setCallback(URI.create((String)params.get("redirect_uri")));
        st.setNonce(nonce);
        this.checkPrompts(params);
        if (params.containsKey("request")) {
            throw new OA2Error("request_not_supported", "The \"request\" parameter is not supported on this server", state, givenRedirect);
        }
        if (params.containsKey("request_uri")) {
            throw new OA2Error("request_uri_not_supported", "The \"request_uri\" parameter is not supported on this server", state, givenRedirect);
        }
        return st;
    }

    protected void checkPrompts(Map<String, String> map) {
        if (!map.containsKey("prompt")) {
            return;
        }
        String prompts = map.get("prompt");
        StringTokenizer st = new StringTokenizer(prompts);
        ArrayList<String> prompt = new ArrayList<String>();
        while (st.hasMoreElements()) {
            prompt.add(st.nextToken());
        }
        if (!prompt.contains("none") && prompt.size() == 0) {
            throw new OA2Error("login_required", "A login is required on this server", map.get("state"));
        }
        if (prompt.contains("none") && 1 < prompt.size()) {
            throw new OA2Error("invalid_request", "You cannot specify \"none\" for the prompt and any other option", map.get("state"));
        }
        if (prompt.contains("login")) {
            return;
        }
        throw new OA2Error("login_required", "You must specify \"login\" as an option", map.get("state"));
    }
}

