/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.oauth2.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.OA2ServiceTransaction;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.ACS2;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.DateUtils;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.server.request.IssuerResponse;
import edu.uiuc.ncsa.security.delegation.server.request.PAResponse;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.oauth_2_0.OA2Error;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class OA2CertServlet
extends ACS2 {
    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws IOException {
        PAResponse par = (PAResponse)iResponse;
        AccessToken accessToken = par.getAccessToken();
        OA2ServiceTransaction t = (OA2ServiceTransaction)this.getTransactionStore().get(accessToken);
        if (!t.getScopes().contains("edu.uiuc.ncsa.myproxy.getcert")) {
            throw new OA2Error("access_denied", "Certificate request is out of scope.", "", t.getCallback());
        }
        if (t == null) {
            throw new GeneralException("Error: no transaction found for access token \"" + accessToken + "\"");
        }
        if (!t.isAccessTokenValid()) {
            throw new GeneralException("Error: invalid access token. Request refused");
        }
        this.checkClient(t.getClient());
        DateUtils.checkTimestamp((String)accessToken.getToken());
        return t;
    }

    protected void checkMPConnection(OA2ServiceTransaction st) throws GeneralSecurityException {
        if (!this.hasMPConnection((ServiceTransaction)st)) {
            this.createMPConnection(st.getIdentifier(), st.getMyproxyUsername(), "", st.getLifetime(), "");
        }
    }

    protected void doRealCertRequest(ServiceTransaction trans, String statusString) throws Throwable {
        if (!trans.getCertReq().getCN().equals(trans.getUsername())) {
            throw new OA2Error("access_denied", "The common name on the cert request is \"" + trans.getCertReq().getCN() + "\" which does not match the username \"" + trans.getUsername() + "\"", "", trans.getCallback());
        }
        OA2ServiceTransaction st = (OA2ServiceTransaction)trans;
        this.checkMPConnection(st);
        this.doCertRequest((ServiceTransaction)st, statusString);
    }
}

