/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.oauth2.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.servlet.OA2AuthorizationServer;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.oauth_2_0.OA2Error;
import edu.uiuc.ncsa.security.servlet.ExceptionHandler;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OA2ExceptionHandler
implements ExceptionHandler {
    public void handleException(Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        OA2Error oa2Error = null;
        String state = request.getParameter("state");
        if (t instanceof OA2Error) {
            oa2Error = (OA2Error)t;
        } else {
            if (t instanceof GeneralException) {
                oa2Error = new OA2Error("server_error", t.getMessage(), state);
            }
            if (oa2Error == null) {
                oa2Error = new OA2Error("server_error", "Internal error:" + t.getMessage(), null);
            }
        }
        this.handleOA2Error(oa2Error, response);
    }

    protected void handleOA2Error(OA2Error oa2Error, HttpServletResponse response) throws IOException {
        if (oa2Error.getCallback() == null) {
            throw new IllegalStateException("No callback has been specified in the request. Cannot process error notification.");
        }
        OA2AuthorizationServer.MyHttpServletResponseWrapper wrapper = null;
        if (response instanceof OA2AuthorizationServer.MyHttpServletResponseWrapper) {
            wrapper = (OA2AuthorizationServer.MyHttpServletResponseWrapper)response;
            wrapper.setExceptionEncountered(true);
        }
        String cb = oa2Error.getCallback().toString();
        cb = cb + "?" + "error" + "=" + oa2Error.getError() + "&" + URLEncoder.encode("error_description", "UTF-8") + "=" + URLEncoder.encode(oa2Error.getDescription(), "UTF-8") + "&" + "state" + "=" + URLEncoder.encode(oa2Error.getState(), "UTF-8");
        response.setStatus(301);
        response.sendRedirect(cb);
    }
}

