/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.oauth2.servlet;

import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.OA2SE;
import edu.uiuc.ncsa.myproxy.oa4mp.server.servlet.MyProxyDelegationServlet;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.InvalidTokenException;
import edu.uiuc.ncsa.security.core.exceptions.TransactionNotFoundException;
import edu.uiuc.ncsa.security.core.util.DateUtils;
import edu.uiuc.ncsa.security.delegation.server.ServiceTransaction;
import edu.uiuc.ncsa.security.delegation.server.request.IssuerResponse;
import edu.uiuc.ncsa.security.delegation.services.Request;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.oauth_2_0.server.UII2;
import edu.uiuc.ncsa.security.oauth_2_0.server.UIIRequest2;
import edu.uiuc.ncsa.security.oauth_2_0.server.UIIResponse2;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UserInfoServlet
extends MyProxyDelegationServlet {
    protected void doIt(HttpServletRequest request, HttpServletResponse response) throws Throwable {
        String rawToken = request.getHeader("authorization");
        AccessToken at = null;
        OA2SE oa2SE = (OA2SE)UserInfoServlet.getServiceEnvironment();
        if (rawToken == null || 0 == rawToken.length()) {
            at = oa2SE.getTokenForge().getAccessToken(request);
        } else {
            rawToken = rawToken.substring(rawToken.indexOf(" ") + 1);
            at = oa2SE.getTokenForge().getAccessToken(new String[]{rawToken});
        }
        if (at == null) {
            throw new GeneralException("Error: no access token was sent.");
        }
        ServiceTransaction transaction = (ServiceTransaction)this.getTransactionStore().get(at);
        if (transaction == null) {
            throw new TransactionNotFoundException("error: The transaction with access token=" + at + " was not found.");
        }
        if (!transaction.isAccessTokenValid()) {
            throw new InvalidTokenException("Error: The access token is not valid.");
        }
        DateUtils.checkTimestamp((String)at.getToken());
        UII2 uis = new UII2(oa2SE.getTokenForge(), UserInfoServlet.getServiceEnvironment().getServiceAddress());
        UIIRequest2 uireq = new UIIRequest2(request, at);
        uireq.setUsername(this.getUsername(transaction));
        UIIResponse2 uiresp = (UIIResponse2)uis.process((Request)uireq);
        oa2SE.getScopeHandler().process(uiresp.getUserInfo(), transaction);
        uiresp.write(response);
    }

    protected String getUsername(ServiceTransaction transaction) {
        return transaction.getUsername();
    }

    public ServiceTransaction verifyAndGet(IssuerResponse iResponse) throws IOException {
        return null;
    }
}

