/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.oauth2.storage;

import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.OA2ServiceTransaction;
import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.storage.RefreshTokenStore;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.cache.RetentionPolicy;
import edu.uiuc.ncsa.security.core.util.DateUtils;
import edu.uiuc.ncsa.security.delegation.token.RefreshToken;
import java.util.Date;
import java.util.Map;

public class RefreshTokenRetentionPolicy
implements RetentionPolicy {
    RefreshTokenStore rts;

    public RefreshTokenRetentionPolicy(RefreshTokenStore rts) {
        this.rts = rts;
    }

    public boolean applies() {
        return true;
    }

    public boolean retain(Object key, Object value) {
        Identifier identifier = (Identifier)key;
        OA2ServiceTransaction st2 = (OA2ServiceTransaction)((Object)value);
        RefreshToken rt = st2.getRefreshToken();
        if (rt == null || rt.getToken() == null) {
            return true;
        }
        Date creationTS = DateUtils.getDate((String)st2.getRefreshToken().getToken());
        return creationTS.getTime() + st2.getRefreshTokenLifetime() <= System.currentTimeMillis();
    }

    public Map getMap() {
        return this.rts;
    }
}

