/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.oauth2.storage;

import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.OA2ServiceTransaction;
import edu.uiuc.ncsa.myproxy.oa4mp.oauth2.storage.OA2TransactionKeys;
import edu.uiuc.ncsa.myproxy.oa4mp.server.util.TransactionConverter;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.delegation.server.storage.ClientStore;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.token.RefreshToken;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.oauth_2_0.OA2TokenForge;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import java.util.Collection;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONSerializer;

public class TConverter2<V extends OA2ServiceTransaction>
extends TransactionConverter<V> {
    public TConverter2(OA2TransactionKeys keys, IdentifiableProvider<V> identifiableProvider, TokenForge tokenForge, ClientStore<? extends Client> cs) {
        super((SerializationKeys)keys, identifiableProvider, tokenForge, cs);
    }

    protected OA2TransactionKeys getTCK() {
        return (OA2TransactionKeys)this.keys;
    }

    protected OA2TokenForge getTF2() {
        return (OA2TokenForge)this.getTokenForge();
    }

    public V fromMap(ConversionMap<String, Object> map, V v) {
        OA2ServiceTransaction st = (OA2ServiceTransaction)super.fromMap(map, v);
        Object refreshToken = map.get((Object)this.getTCK().refreshToken(new String[0]));
        if (refreshToken != null) {
            if (refreshToken instanceof RefreshToken) {
                st.setRefreshToken((RefreshToken)refreshToken);
            } else {
                st.setRefreshToken(this.getTF2().getRefreshToken(new String[]{refreshToken.toString()}));
            }
        }
        st.setRefreshTokenValid(map.getBoolean((Object)this.getTCK().refreshTokenValid(new String[0])));
        st.setRefreshTokenLifetime(map.getLong((Object)this.getTCK().expiresIn(new String[0])));
        st.setCallback(map.getURI((Object)this.getTCK().callbackUri(new String[0])));
        st.setNonce(map.getString((Object)this.getTCK().nonce(new String[0])));
        if (map.get((Object)this.getTCK().scopes(new String[0])) != null) {
            JSONArray json = (JSONArray)JSONSerializer.toJSON((Object)map.get((Object)this.getTCK().scopes(new String[0])));
            Collection zzz = (Collection)JSONSerializer.toJava((JSON)json);
            st.setScopes(zzz);
        }
        if (map.get((Object)this.getTCK().authTime(new String[0])) != null) {
            st.setAuthTime(map.getDate((Object)this.getTCK().authTime));
        }
        return (V)((Object)st);
    }

    public void toMap(V t, ConversionMap<String, Object> map) {
        super.toMap(t, map);
        if (((OA2ServiceTransaction)((Object)t)).getRefreshToken() != null) {
            map.put((Object)this.getTCK().refreshToken(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).getRefreshToken().getToken());
        }
        map.put((Object)this.getTCK().refreshTokenValid(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).isRefreshTokenValid());
        if (t.getCallback() != null) {
            map.put((Object)this.getTCK().callbackUri(new String[0]), (Object)t.getCallback().toString());
        }
        map.put((Object)this.getTCK().expiresIn(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).getRefreshTokenLifetime());
        if (((OA2ServiceTransaction)((Object)t)).getNonce() != null && 0 < ((OA2ServiceTransaction)((Object)t)).getNonce().length()) {
            map.put((Object)this.getTCK().nonce(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).getNonce());
        }
        if (((OA2ServiceTransaction)((Object)t)).getScopes().isEmpty()) {
            return;
        }
        JSONArray jsonArray = new JSONArray();
        for (String s : ((OA2ServiceTransaction)((Object)t)).getScopes()) {
            jsonArray.add((Object)s);
        }
        map.put((Object)this.getTCK().scopes(new String[0]), (Object)jsonArray.toString());
        if (((OA2ServiceTransaction)((Object)t)).hasAuthTime()) {
            map.put((Object)this.getTCK().authTime(new String[0]), (Object)((OA2ServiceTransaction)((Object)t)).getAuthTime());
        }
    }
}

