/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.common.cluster;

import com.hazelcast.config.Config;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.cluster.Versions;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.session.hazelcast.config.annotation.web.http.EnableHazelcastHttpSession;
import org.springframework.session.web.http.DefaultCookieSerializer;

@Configuration(proxyBeanMethods=false)
@EnableHazelcastHttpSession
public class HazelcastHttpSessionConfig {
    private final Logger logger = LoggerFactory.getLogger(HazelcastHttpSessionConfig.class);
    protected final String appname;
    protected final String groupName;
    protected final boolean isDevmode;
    protected final String members;
    protected final int port;

    protected HazelcastHttpSessionConfig(Environment env, @Value(value="${application.proxy.cluster.members:127.0.0.1}") String members, @Value(value="${application.proxy.cluster.port:5701}") int port, @Value(value="${spring.application.name}") String appname, @Value(value="${spring.profiles.active}") String profileName) {
        this.isDevmode = env.acceptsProfiles(Profiles.of((String[])new String[]{"dev"}));
        this.members = members;
        this.port = port;
        this.appname = appname;
        this.groupName = this.isDevmode ? this.appname + "#" + System.getProperty("user.name") : this.appname + "@" + profileName;
        this.logger.info("Hazelcast Http Session Configuration initiated with {}", (Object)members);
    }

    @PostConstruct
    protected void initiated() {
        this.logger.info("Hazelcast Clustered Configuration initiated");
    }

    @Bean(destroyMethod="shutdown")
    protected HazelcastInstance embeddedHazelcast() {
        Config config = new Config();
        config.setProperty("hazelcast.logging.type", "slf4j").setClusterName(this.groupName + ":" + Versions.CURRENT_CLUSTER_VERSION);
        JoinConfig join = config.getNetworkConfig().setPort(this.port).setReuseAddress(true).getJoin();
        join.getMulticastConfig().setEnabled(false);
        join.getTcpIpConfig().addMember(this.members).setEnabled(true);
        return Hazelcast.newHazelcastInstance((Config)config);
    }

    @Bean
    protected DefaultCookieSerializer cookieSerializer() {
        DefaultCookieSerializer serializer = new DefaultCookieSerializer();
        serializer.setCookieName("DGSESSION");
        if (this.isDevmode) {
            serializer.setUseSecureCookie(false);
        }
        return serializer;
    }
}

