/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DogisContextHolder
implements Closeable {
    private static final ThreadLocal<Holder> context = new ThreadLocal();

    static DogisContextHolder getDogisContextHolder(HttpServletRequest request) {
        return new DogisContextHolder(request){};
    }

    public static void setNamedValue(String key, Object value) {
        Objects.requireNonNull(key, "Missing value key");
        if (value == null) {
            DogisContextHolder.getHolder().namedValues.remove(key);
        } else {
            DogisContextHolder.getHolder().namedValues.put(key, value);
        }
    }

    public static Object getNamedValue(String key) {
        return key == null ? null : DogisContextHolder.getHolder().namedValues.get(key);
    }

    public static HttpServletRequest getWrappedRequest() {
        return DogisContextHolder.getHolder().request;
    }

    protected static Holder getHolder() {
        Holder holder = context.get();
        if (holder == null) {
            throw new IllegalStateException("No thread-bound request found: Are you referring to request Dogis attributes outside of an actual web request, or processing a request outside of the originally receiving thread?");
        }
        return holder;
    }

    private DogisContextHolder(HttpServletRequest request) {
        Holder holder = new Holder(request);
        context.set(holder);
    }

    @Override
    public void close() throws IOException {
        context.remove();
    }

    private static class Holder {
        protected final Map<String, Object> namedValues = new HashMap<String, Object>();
        protected final HttpServletRequest request;

        public Holder(HttpServletRequest request) {
            this.request = request;
        }
    }
}

