/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.config;

import ee.datel.dogis.configuration.ConfigurationFileManager;
import ee.datel.dogis.configuration.ConfigurationFilter;
import ee.datel.dogis.configuration.ConfigurationManager;
import ee.datel.dogis.configuration.ConfigurationOnCloud;
import ee.datel.dogis.utils.DogisUtils;
import ee.datel.dogis.utils.JsonParserService;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;

@Configuration(proxyBeanMethods=false)
@ConditionalOnExpression(value="'${application.proxy.configuration.store.url:}' == ''")
public class ConfigurationFilestoreConfiguration {
    private final ConfigurationFilter configurationFilter;
    private final JsonParserService parser;
    private final String confPath;
    private final boolean devmode;
    private final String debug;
    private final boolean readonly;

    protected ConfigurationFilestoreConfiguration(ConfigurationFilter filter, JsonParserService parser, @Value(value="${application.proxy.configuration.store.path}") String confPath, Environment env, @Value(value="${application.debug.approot:}") String debug, @Autowired(required=false) ConfigurationOnCloud onCloud) {
        this.configurationFilter = filter;
        this.confPath = confPath;
        this.parser = parser;
        this.devmode = env.acceptsProfiles(Profiles.of((String[])new String[]{"dev"}));
        this.debug = debug;
        this.readonly = onCloud != null;
    }

    @Bean
    protected ConfigurationManager configurationReader() {
        LoggerFactory.getLogger(ConfigurationFilestoreConfiguration.class).info("{}", (Object)"ConfigurationFileManager initiated");
        return new ConfigurationFileManager(this.confPath, this.configurationFilter, this.parser, DogisUtils.defaultLocale().getLanguage(), this.devmode, this.debug, this.readonly);
    }
}

