/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.config;

import ee.datel.dogis.dictionary.DictionaryFileReader;
import ee.datel.dogis.dictionary.DictionaryFilestoreProvider;
import ee.datel.dogis.dictionary.DictionaryProvider;
import ee.datel.dogis.utils.JsonParserService;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;

@Configuration
@ConditionalOnExpression(value="'${application.dictionary.repository:}' == 'json'")
public class DictionaryFilestoreConfiguration {
    public static final String CONFSTORENAME = "${application.proxy.configuration.store.path}";
    private static final String FILE_NAME = "dictionary.json";
    private final boolean isDev;
    private final String debug;

    protected DictionaryFilestoreConfiguration(Environment env, @Value(value="${application.debug.approot:}") String debug) {
        this.isDev = env.acceptsProfiles(Profiles.of((String[])new String[]{"dev"}));
        this.debug = debug;
    }

    @Bean
    protected DictionaryFileReader dictionaryFileReader(JsonParserService parser, Path dict) {
        return new DictionaryFileReader(dict, parser);
    }

    @Bean
    protected DictionaryProvider dictionaryProvider(JsonParserService parser, @Value(value="${application.proxy.configuration.store.path}") String confPath) {
        Path conf;
        Logger logger = LoggerFactory.getLogger(DictionaryFilestoreConfiguration.class);
        logger.info("Dictionary File Storage Service initiated");
        try {
            conf = FileSystems.getDefault().getPath(confPath, new String[0]);
            if (!conf.isAbsolute()) {
                if (!this.isDev) {
                    logger.error("Configuration path is not absolut: {}", (Object)confPath);
                    throw new IllegalArgumentException("Configuration path is not absolut: " + confPath);
                }
                conf = FileSystems.getDefault().getPath(this.debug, new String[0]).resolve(confPath);
            }
        }
        catch (InvalidPathException ex) {
            logger.error("Invalid path \"{}\"!", (Object)confPath, (Object)ex);
            throw new IllegalArgumentException(ex.getMessage());
        }
        conf = conf.getParent();
        if (conf == null || !conf.toFile().exists()) {
            logger.error("Configuration path \"{}={}\" is wrong!", (Object)CONFSTORENAME, (Object)confPath);
            throw new IllegalStateException((String)(conf == null ? confPath + ".parent()" : conf.toString()) + " not exist!");
        }
        Path dict = conf.resolve(FILE_NAME);
        if (!dict.toFile().exists()) {
            logger.error("Dictionary file not found \"{}\"!", (Object)dict);
            throw new IllegalArgumentException(dict.toString() + " not exist!");
        }
        return new DictionaryFilestoreProvider(this.dictionaryFileReader(parser, dict));
    }
}

