/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.configuration;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import ee.datel.dogis.configuration.ConfigurationFilter;
import ee.datel.dogis.configuration.ConfigurationManager;
import ee.datel.dogis.exception.Http404Exception;
import ee.datel.dogis.exception.HttpStatusException;
import ee.datel.dogis.exception.ManagedException;
import ee.datel.dogis.utils.CommonUtils;
import ee.datel.dogis.utils.JsonParserService;
import ee.datel.dogis.utils.Utf8propertiesLoader;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.http.HttpSession;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;

public class ConfigurationFileManager
implements ConfigurationManager {
    private final Logger logger = LoggerFactory.getLogger(ConfigurationFileManager.class);
    private final String defaultLang;
    private final ConfigurationFilter filter;
    private final String propertie;
    private final JsonParserService parser;
    private final boolean isDev;
    private boolean isReadonly;
    private final String debugroot;
    protected AtomicReference<List<String>> applications = new AtomicReference();
    protected AtomicReference<List<String>> applicationsUnhidden = new AtomicReference();
    private AtomicReference<Map<String, Map<String, String>>> layers = new AtomicReference();
    private final Lock applicationsLock = new ReentrantLock();
    private final Lock layersLock = new ReentrantLock();
    private final Cache<String, Map<String, Object>> configurationCache = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.SECONDS).build();
    private Path storageRootPath;
    protected Path confAppPath;
    protected Path confFatPath;
    private FileSystem confFileSystem;
    private WatchService appWatcher;
    private Thread appWatcherSrv;
    private final Set<Path> registeredWatchers = ConcurrentHashMap.newKeySet();

    public ConfigurationFileManager(String propertie, ConfigurationFilter filter, JsonParserService parser, String defaultLang, boolean isDev, String debugroot, boolean readonly) {
        this.propertie = propertie;
        this.filter = filter;
        this.parser = parser;
        this.defaultLang = defaultLang;
        this.isDev = isDev;
        this.debugroot = debugroot;
        this.isReadonly = readonly;
    }

    @Override
    public String getApplicationTimestamp(String appid) {
        try {
            Path path = this.getApplicationFilePath(appid);
            return this.getTimestamp(path);
        }
        catch (Http404Exception ex) {
            return null;
        }
    }

    @Override
    public String getLayerTimestamp(String layerName) {
        try {
            Path path = this.resolveFatFilePath(layerName);
            return this.getTimestamp(path);
        }
        catch (Http404Exception ex) {
            return null;
        }
    }

    protected String getTimestamp(Path path) {
        try {
            FileTime lastmodified = Files.getLastModifiedTime(path, new LinkOption[0]);
            Instant instant = lastmodified.toInstant();
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toString();
        }
        catch (IOException ex) {
            this.logger.warn("File {} getLastModifiedTime throws {}", (Object)path, (Object)ex.getMessage());
            return null;
        }
    }

    @Override
    public void saveLayer(String layerName, String json) throws IOException {
        if (!this.isDeployable()) {
            throw new IllegalStateException("Not deployable configuration storage");
        }
        Path lay = this.confFatPath.resolve(layerName + ".json");
        try (BufferedWriter wrt = Files.newBufferedWriter(lay, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            wrt.write(json);
        }
    }

    @Override
    public void addLayers(Set<String> fatLayers, Path dir) throws IOException {
        if (!this.isDeployable()) {
            throw new IllegalStateException("Not deployable configuration storage");
        }
        for (String layer : fatLayers) {
            Path lay = this.confFatPath.resolve(layer + ".json");
            Files.copy(lay, dir.resolve(lay.getFileName().toString()), new CopyOption[0]);
        }
    }

    @Override
    public void addApplication(String appid, Path dir) throws IOException {
        if (!this.isDeployable()) {
            throw new IllegalStateException("Not deployable configuration storage");
        }
        Path path = this.confAppPath.resolve(appid);
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(path);){
            for (Path fl : dirStream) {
                Files.copy(fl, dir.resolve(fl.getFileName().toString()), new CopyOption[0]);
            }
        }
    }

    @Override
    public void deployApplication(String appid, Path dir) throws IOException {
        if (!this.isDeployable()) {
            throw new IllegalStateException("Not deployable configuration storage");
        }
        if (!Files.exists(dir, new LinkOption[0])) {
            this.logger.warn("Invalid {} zip structure, missing {}", (Object)appid, (Object)dir);
            return;
        }
        Path app = this.confAppPath.resolve(appid);
        if (app.toFile().exists()) {
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(app);){
                for (Path fl : dirStream) {
                    Files.delete(fl);
                }
            }
        } else {
            Files.createDirectory(app, new FileAttribute[0]);
        }
        boolean empty = true;
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir);){
            for (Path fl : dirStream) {
                empty = false;
                Files.copy(fl, app.resolve(fl.getFileName().toString()), new CopyOption[0]);
            }
        }
        if (empty) {
            this.logger.warn("Empty{} in {}.zip", (Object)dir, (Object)appid);
            Files.delete(app);
        }
    }

    @Override
    public void deployLayers(Path dir) throws IOException {
        if (!this.isDeployable()) {
            throw new IllegalStateException("Not deployable configuration storage");
        }
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir);){
            for (Path fl : dirStream) {
                Files.copy(fl, this.confFatPath.resolve(fl.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }

    @Override
    public boolean isDeployable() {
        return !this.isReadonly;
    }

    @Override
    public Path getStorePath() {
        return this.storageRootPath;
    }

    @Override
    public Map<String, Map<String, String>> getFatLayerList() {
        Map<String, Map<String, String>> list = this.layers.get();
        if (list == null) {
            list = this.collectLayers();
        }
        return list;
    }

    @Override
    public List<String> getApplicationsSelectableList() {
        List<String> list = this.applicationsUnhidden.get();
        if (list == null) {
            list = this.collectUnhiddenApplications();
        }
        return list;
    }

    @Override
    public List<String> getApplicationsList() {
        List<String> list = this.applications.get();
        if (list == null) {
            list = this.collectApplications();
        }
        return list;
    }

    @Override
    public Properties getAppDictionary(String appid, String language) throws IOException {
        try {
            return (Properties)((Map)this.configurationCache.get((Object)CommonUtils.concatenate((CharSequence[])new CharSequence[]{"dictionary:", language, "#", appid}), () -> this.getTheAppDictionary(appid, language))).get("dictionary");
        }
        catch (ExecutionException ex) {
            throw (IOException)ex.getCause();
        }
    }

    private Map<String, Object> getTheAppDictionary(String appid, String language) throws IOException {
        Path appPath = this.resolveAppPath(appid);
        Path filePath = appPath.resolve("messages_" + this.defaultLang + ".properties");
        Properties props = new Properties();
        Utf8propertiesLoader.getLoader().loadProperties(filePath, props);
        if (!this.defaultLang.equals(language)) {
            filePath = appPath.resolve("messages_" + language + ".properties");
            Utf8propertiesLoader.getLoader().loadProperties(filePath, props);
        }
        return Collections.singletonMap("dictionary", props);
    }

    @Override
    public Resource getApplicationManual(String appid, String page, String language) throws HttpStatusException {
        Path appPath = this.resolveAppPath(appid);
        Path manualPath = appPath.resolve(page + "_" + language + ".html");
        if (!this.filesExists(manualPath)) {
            if (!this.defaultLang.equals(language)) {
                manualPath = appPath.resolve(page + "_" + this.defaultLang + ".html");
                if (!this.filesExists(manualPath)) {
                    manualPath = null;
                }
            } else {
                manualPath = null;
            }
        }
        return manualPath == null ? null : new FileSystemResource(manualPath);
    }

    @Override
    public Resource getApplicationManual(String appid, String language) throws HttpStatusException {
        Path appPath = this.resolveAppPath(appid);
        Path manualPath = appPath.resolve("manual_" + language + ".html");
        if (!this.filesExists(manualPath) && !this.filesExists(manualPath = appPath.resolve("manual_" + language + ".pdf"))) {
            if (!this.defaultLang.equals(language)) {
                manualPath = appPath.resolve("manual_" + this.defaultLang + ".html");
                if (!this.filesExists(manualPath) && !this.filesExists(manualPath = appPath.resolve("manual_" + this.defaultLang + ".pdf"))) {
                    manualPath = null;
                }
            } else {
                manualPath = null;
            }
        }
        return manualPath == null ? null : new FileSystemResource(manualPath);
    }

    @Override
    public Map<String, Object> readApplicationConfiguration(String appid, HttpSession session) throws HttpStatusException {
        Path file = this.getApplicationFilePath(appid);
        return this.readConfiguration(file, session);
    }

    @Override
    public Map<String, Object> getFatLayer(String layerid, HttpSession session) throws HttpStatusException {
        Path file = this.resolveFatFilePath(layerid);
        return this.readConfiguration(file, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Map<String, String>> collectLayers() {
        this.layersLock.lock();
        try {
            if (this.layers.get() == null) {
                Map<Object, Object> readed;
                long start = System.currentTimeMillis();
                try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(this.confFatPath, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
                    readed = StreamSupport.stream(dirStream.spliterator(), false).map(dir -> dir.getFileName().toString()).filter(val -> val.endsWith(".json")).map(val -> val.substring(0, val.lastIndexOf(46))).collect(Collectors.toMap(n -> n, this::readLayerData));
                }
                catch (Exception ex) {
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                    readed = Collections.emptyMap();
                }
                this.logger.info("Collect Layers in {}ms", (Object)(System.currentTimeMillis() - start));
                this.layers.set(readed);
            }
            Map<String, Map<String, String>> map = this.layers.get();
            return map;
        }
        finally {
            this.layersLock.unlock();
        }
    }

    private Map<String, String> readLayerData(String name) {
        HashMap<String, String> layer = new HashMap<String, String>();
        try {
            Collection is;
            Map mp;
            Path file = this.resolveFatFilePath(name);
            Map<String, Object> one = this.readFile(file);
            String val = (String)one.get("tags");
            layer.put("tags", StringUtils.isBlank((CharSequence)val) ? "" : val);
            val = (String)one.get("metainfo");
            layer.put("metainfo", StringUtils.isBlank((CharSequence)val) ? "" : val);
            Object map = one.get("map");
            if (map instanceof Map && !(mp = (Map)map).isEmpty() || map instanceof Collection && !(is = (Collection)map).isEmpty()) {
                layer.put("visual", "visual");
            }
            if (one.get("hidden") != null && StringUtils.isNotBlank((CharSequence)one.get("hidden").toString())) {
                layer.put("hidden", "hidden");
            }
        }
        catch (Exception ex) {
            this.logger.warn(ex.getMessage(), (Throwable)ex);
        }
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> collectUnhiddenApplications() {
        this.applicationsLock.lock();
        try {
            if (this.applicationsUnhidden.get() == null) {
                List<Object> readed;
                long start = System.currentTimeMillis();
                try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(this.confAppPath, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
                    readed = StreamSupport.stream(dirStream.spliterator(), false).map(file -> file.getFileName().toString()).filter(this::ifUnhiddenApp).toList();
                }
                catch (Exception ex) {
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                    readed = List.of();
                }
                this.logger.info("Collect Unhidden Applications in {}ms", (Object)(System.currentTimeMillis() - start));
                this.applicationsUnhidden.set(readed);
            }
            List<String> list = this.applicationsUnhidden.get();
            return list;
        }
        finally {
            this.applicationsLock.unlock();
        }
    }

    private boolean ifUnhiddenApp(String appid) {
        try {
            Path file = this.getApplicationFilePath(appid);
            Map<String, Object> conf = this.readFile(file);
            Object hidden = conf.get("hidden");
            if (hidden == null) {
                return true;
            }
            if (hidden instanceof Boolean) {
                Boolean is = (Boolean)hidden;
                return is == false;
            }
            return !"true".equals(conf.get("hidden"));
        }
        catch (Http404Exception file) {
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> collectApplications() {
        this.applicationsLock.lock();
        try {
            if (this.applications.get() == null) {
                List<Object> readed;
                long start = System.currentTimeMillis();
                try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(this.confAppPath, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
                    readed = StreamSupport.stream(dirStream.spliterator(), false).map(dir -> dir.getFileName().toString()).filter(this::testApplicationFilePath).toList();
                }
                catch (Exception ex) {
                    this.logger.error(ex.getMessage(), (Throwable)ex);
                    readed = List.of();
                }
                this.logger.info("Collect Applications in {}ms", (Object)(System.currentTimeMillis() - start));
                this.applications.set(readed);
            }
            List<String> list = this.applications.get();
            return list;
        }
        finally {
            this.applicationsLock.unlock();
        }
    }

    private boolean testApplicationFilePath(String appid) {
        try {
            this.getApplicationFilePath(appid);
            return true;
        }
        catch (Http404Exception ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> readFile(Path file) throws IOException {
        try (InputStreamReader in = new InputStreamReader((InputStream)new BufferedInputStream((InputStream)((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(Files.newInputStream(file, StandardOpenOption.READ))).get()), StandardCharsets.UTF_8);){
            Map map;
            StringBuilder sb = CommonUtils.popBuffer();
            try {
                map = this.parser.parseJson((Reader)in, sb);
            }
            catch (Throwable throwable) {
                CommonUtils.push((StringBuilder)sb);
                throw throwable;
            }
            CommonUtils.push((StringBuilder)sb);
            return map;
        }
    }

    private Map<String, Object> readConfiguration(Path file, HttpSession session) throws HttpStatusException {
        try {
            return (Map)this.configurationCache.get((Object)CommonUtils.concatenate((CharSequence[])new CharSequence[]{file.toString()}), () -> this.readTheConfiguration(file, session));
        }
        catch (ExecutionException ex) {
            throw (HttpStatusException)ex.getCause();
        }
    }

    protected Map<String, Object> readTheConfiguration(Path file, HttpSession session) throws HttpStatusException {
        Map<String, Object> map;
        BufferedInputStream in = new BufferedInputStream((InputStream)((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(Files.newInputStream(file, StandardOpenOption.READ))).get());
        try {
            map = this.filter.getApplicationConfiguration(in, session);
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ManagedException ex) {
                throw new HttpStatusException((HttpStatusCode)(ex.getOffender() == ManagedException.Reason.CLIENT ? HttpStatus.BAD_REQUEST : HttpStatus.INTERNAL_SERVER_ERROR), ex.getMessage());
            }
            catch (Exception ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
                if (this.isDev) {
                    throw new HttpStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Configuration read error: " + ex.getMessage());
                }
                throw new HttpStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "exception.configuration.read.error");
            }
        }
        in.close();
        return map;
    }

    protected Path getApplicationFilePath(String appid) throws Http404Exception {
        Path file = this.resolveAppPath(appid).resolve("application.json");
        if (!this.filesExists(file)) {
            throw new Http404Exception("Application \"" + appid + "\" - missing file application.json");
        }
        return file;
    }

    protected Path resolveAppPath(String appid) throws Http404Exception {
        Path file = this.confAppPath.resolve(appid);
        if (!this.filesExists(file)) {
            if (this.isDev) {
                throw new Http404Exception("Application \"" + appid + "\" not found!");
            }
            throw new Http404Exception("exception.configuration.missing.application");
        }
        return file;
    }

    protected Path resolveFatFilePath(String layerid) throws Http404Exception {
        Path file = this.confFatPath.resolve(layerid + ".json");
        if (!this.filesExists(file)) {
            if (this.isDev) {
                throw new Http404Exception("Layer \"" + layerid + "\" not found!");
            }
            throw new Http404Exception("exception.configuration.missing.fatlayer");
        }
        return file;
    }

    @PostConstruct
    protected void init() {
        File file;
        Path conf;
        try {
            conf = FileSystems.getDefault().getPath(this.propertie, new String[0]);
            if (!conf.isAbsolute()) {
                if (!this.isDev) {
                    this.logger.error("Configuration path is not absolut: {}", (Object)this.propertie);
                    throw new IllegalArgumentException("Configuration path is not absolut: " + this.propertie);
                }
                conf = FileSystems.getDefault().getPath(this.debugroot, new String[0]).resolve(this.propertie).normalize();
            }
            file = conf.toFile();
        }
        catch (InvalidPathException ex) {
            this.logger.error("Invalid path \"{}\"!", (Object)this.propertie, (Object)ex);
            throw new IllegalArgumentException(ex.getMessage());
        }
        if (!file.exists()) {
            this.logger.error("Configuration path \"{}={}\" is not exist!", (Object)"${application.proxy.configuration.store.path}", (Object)conf);
            throw new IllegalStateException(conf.toString() + " not exist!");
        }
        Path confPath = this.getConfPath(file, conf);
        this.confAppPath = confPath.resolve("applications");
        this.confFatPath = confPath.resolve("layers");
        if (this.confFileSystem == null) {
            this.storageRootPath = confPath.getParent();
            this.createWatchers();
        }
    }

    protected Path getConfPath(File file, Path conf) {
        Path confPath;
        if (file.isDirectory()) {
            confPath = conf;
        } else {
            try {
                URI uri = URI.create("jar:" + conf.toUri().toString());
                HashMap env = new HashMap();
                this.confFileSystem = FileSystems.newFileSystem(uri, env);
                confPath = this.confFileSystem.getRootDirectories().iterator().next();
                this.isReadonly = true;
            }
            catch (Exception ex) {
                this.logger.error("Invalid ZIP file {} - {}", new Object[]{conf, ex.getMessage(), ex});
                this.destroy();
                throw new IllegalStateException(ex.getMessage());
            }
        }
        this.logger.info("Initiated on PATH: {}", (Object)confPath);
        return confPath;
    }

    protected boolean filesExists(Path file) {
        return file.toFile().exists();
    }

    protected void createWatchers() {
        try {
            this.appWatcher = FileSystems.getDefault().newWatchService();
            this.appWatcherSrv = this.createWatcherSrv(this.confAppPath);
            this.confFatPath.register(this.appWatcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
            this.addAppWatchers();
            this.appWatcherSrv.start();
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    protected void addAppWatchers() throws IOException {
        try (DirectoryStream<Path> dirs = Files.newDirectoryStream(this.confAppPath, path -> path.toFile().isDirectory() && !this.registeredWatchers.contains(path));){
            dirs.forEach(path -> {
                try {
                    path.register(this.appWatcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
                }
                catch (IOException ex) {
                    this.logger.warn("{} {}", path, (Object)ex.getMessage());
                }
                this.registeredWatchers.add((Path)path);
            });
        }
    }

    protected Thread createWatcherSrv(Path path) throws IOException {
        path.register(this.appWatcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        return new Thread(() -> {
            Thread.currentThread().setName("configuration-watcher");
            while (true) {
                try {
                    while (true) {
                        WatchKey key = this.appWatcher.take();
                        key.pollEvents();
                        this.applications.set(null);
                        this.applicationsUnhidden.set(null);
                        this.layers.set(null);
                        this.configurationCache.invalidateAll();
                        this.addAppWatchers();
                        key.reset();
                    }
                }
                catch (InterruptedException | ClosedWatchServiceException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException ex) {
                    CommonUtils.doNothing((Throwable)ex);
                    continue;
                }
                break;
            }
        });
    }

    @PreDestroy
    protected void destroy() {
        if (this.confFileSystem != null && this.confFileSystem.isOpen()) {
            try {
                this.confFileSystem.close();
            }
            catch (IOException ex) {
                this.logger.warn(ex.getMessage(), (Throwable)ex);
            }
        }
        if (this.appWatcher != null) {
            try {
                this.appWatcher.close();
            }
            catch (IOException ex) {
                this.logger.warn(ex.getMessage());
            }
        }
        if (this.appWatcherSrv != null) {
            this.appWatcherSrv.interrupt();
        }
    }
}

