/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.configuration;

import ee.datel.dogis.exception.HttpStatusException;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.io.Resource;

public interface ConfigurationManager {
    public static final String APPROOT = "applications";
    public static final String FATROOT = "layers";
    public static final String CONF_FILENAME = "application.json";
    public static final String MESSAGES = "messages_";
    public static final String MANUAL = "manual_";
    public static final String JSON = ".json";
    public static final String PROPS = ".properties";
    public static final String PDF = ".pdf";
    public static final String HTML = ".html";
    public static final String METAINFO = "metainfo";
    public static final String TAGS = "tags";
    public static final String VISUAL = "visual";
    public static final String HIDDEN = "hidden";
    public static final String NOTDEPLOYABLE = "Not deployable configuration storage";

    default public Optional<String> getSuperApplication(String appid) {
        return Local.applicationParent.getOrDefault(appid, Optional.empty());
    }

    public boolean isDeployable();

    default public Map<String, Object> getApplicationConfiguration(String appid, HttpSession session) throws HttpStatusException {
        Map<String, Object> app = this.readApplicationConfiguration(appid, session);
        Local.applicationParent.computeIfAbsent(appid, a -> Optional.ofNullable((String)app.get("coreAppId")));
        return app;
    }

    public Map<String, Object> readApplicationConfiguration(String var1, HttpSession var2) throws HttpStatusException;

    public Map<String, Object> getFatLayer(String var1, HttpSession var2) throws HttpStatusException;

    public Resource getApplicationManual(String var1, String var2) throws HttpStatusException;

    public Resource getApplicationManual(String var1, String var2, String var3) throws HttpStatusException;

    public Properties getAppDictionary(String var1, String var2) throws IOException;

    public List<String> getApplicationsList();

    public List<String> getApplicationsSelectableList();

    public Map<String, Map<String, String>> getFatLayerList();

    public void deployApplication(String var1, Path var2) throws IOException;

    public void deployLayers(Path var1) throws IOException;

    public Path getStorePath();

    public void addLayers(Set<String> var1, Path var2) throws IOException;

    public void addApplication(String var1, Path var2) throws IOException;

    public void saveLayer(String var1, String var2) throws IOException;

    public String getApplicationTimestamp(String var1);

    public String getLayerTimestamp(String var1);

    public static class Local {
        protected static final Map<String, Optional<String>> applicationParent = new ConcurrentHashMap<String, Optional<String>>();

        private Local() {
        }
    }
}

