/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.dictionary;

import ee.datel.dogis.utils.CommonUtils;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;

public record DictionaryEntry(String language, String key, String translated) implements Serializable,
Comparable<DictionaryEntry>
{
    private final String translated;

    public DictionaryEntry(String language, String category, String entity, String property, String telos, String value) {
        this(language, CommonUtils.concatenate((CharSequence[])new CharSequence[]{category, ".", entity, ".", property, ".", telos}), value);
    }

    public static Comparator<DictionaryEntry> comparingByKey() {
        return DictionaryEntry::compareTo;
    }

    public String translated() {
        return this.translated == null ? this.key.substring(this.key.indexOf(46) + 1) : this.translated;
    }

    public String category() {
        return this.key.substring(0, this.key.indexOf(46));
    }

    public String entity() {
        int pos = this.key.indexOf(46) + 1;
        return this.key.substring(pos, this.key.indexOf(46, pos));
    }

    public String property() {
        int pos = this.key.indexOf(46) + 1;
        return this.key.substring(this.key.indexOf(46, pos) + 1, this.key.lastIndexOf(46));
    }

    public String telos() {
        return this.key.substring(this.key.lastIndexOf(46) + 1);
    }

    @Override
    public int compareTo(DictionaryEntry co) {
        if (this.language.equals(co.language)) {
            return this.key.equals(co.key) ? 0 : this.key.compareTo(co.key);
        }
        return this.language.compareTo(co.language);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass().getName());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DictionaryEntry) {
            DictionaryEntry is = (DictionaryEntry)obj;
            return Objects.equals(this.language, is.language) && Objects.equals(this.key, is.key);
        }
        return false;
    }
}

