/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.dictionary;

import ee.datel.dogis.dictionary.DictionaryEntry;
import ee.datel.dogis.dictionary.DictionaryReader;
import ee.datel.dogis.exception.ManagedServerException;
import ee.datel.dogis.utils.CommonUtils;
import ee.datel.dogis.utils.JsonParserService;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryFileReader
extends DictionaryReader {
    private static final long CACHETIMEOUT = 60000L;
    private final Logger logger = LoggerFactory.getLogger(DictionaryFileReader.class);
    private final JsonParserService parser;
    private final Path dictPath;
    private final AtomicLong validTo = new AtomicLong();
    private FileTime dictionaryTimestamp;

    public DictionaryFileReader(Path dictPath, JsonParserService parser) {
        this.parser = parser;
        this.dictPath = dictPath;
        this.logger.info("Initiated from {}", (Object)dictPath);
    }

    @Override
    protected List<Object> readDictionaryFromSource() throws ManagedServerException {
        StringBuilder sb = CommonUtils.popBuffer();
        try {
            List list;
            block11: {
                BufferedReader rd = Files.newBufferedReader(this.dictPath);
                try {
                    list = this.parser.parseJsonList((Reader)rd, sb);
                    if (rd == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (rd != null) {
                            try {
                                ((Reader)rd).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        this.logger.error(ex.getMessage(), (Throwable)ex);
                        throw new ManagedServerException(ex.getMessage());
                    }
                }
                ((Reader)rd).close();
            }
            return list;
        }
        finally {
            CommonUtils.push((StringBuilder)sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBook(Set<DictionaryEntry> book) {
        this.lock.lock();
        try (BufferedWriter wrt = Files.newBufferedWriter(this.dictPath, new OpenOption[0]);){
            this.parser.getObjectMapper().writeValue((Writer)wrt, book);
            this.dictionary.set(null);
            this.validTo.set(0L);
            this.logger.info("Dictionary book saved");
        }
        catch (IOException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void readDictionaryMetadata() throws ManagedServerException {
        if (this.validTo.get() >= System.currentTimeMillis()) return;
        if (this.lock.tryLock()) {
            try {
                FileTime timestmp = this.getPathTimestamp(this.dictPath);
                if (timestmp.equals(this.dictionaryTimestamp)) return;
                this.dictionaryTimestamp = timestmp;
                this.dictionary.set(null);
                return;
            }
            finally {
                this.validTo.set(System.currentTimeMillis() + 60000L);
                this.lock.unlock();
            }
        } else {
            this.lock.lock();
            this.lock.unlock();
        }
    }

    protected FileTime getPathTimestamp(Path path) {
        try {
            return Files.getLastModifiedTime(path, new LinkOption[0]);
        }
        catch (IOException ex) {
            this.logger.warn("File {} getLastModifiedTime throws {}", (Object)path, (Object)ex.getMessage());
            return FileTime.from(Instant.parse("2000-01-01T00:00:00Z"));
        }
    }
}

