/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.dictionary;

import ee.datel.dogis.dictionary.DictionaryEntry;
import ee.datel.dogis.dictionary.DictionaryFileReader;
import ee.datel.dogis.dictionary.DictionaryProviderCommon;
import ee.datel.dogis.exception.ManagedException;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.scheduling.annotation.Scheduled;

public class DictionaryFilestoreProvider
extends DictionaryProviderCommon {
    private final DictionaryFileReader dictionaryReader;
    private final Lock lock = new ReentrantLock();

    public DictionaryFilestoreProvider(DictionaryFileReader dictionaryReader) {
        super(dictionaryReader);
        this.dictionaryReader = dictionaryReader;
    }

    @Scheduled(fixedDelay=60000L, initialDelay=300000L)
    public void checkBook() {
        if (!((Set)this.newKeys.get()).isEmpty()) {
            Set saveKeys = this.newKeys.getAndSet(new ConcurrentSkipListSet());
            this.saveBookAddKeys(saveKeys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveBookAddKeys(Set<DictionaryEntry> saveKeys) {
        this.lock.lock();
        try {
            Set<DictionaryEntry> book = this.dictionaryReader.readDictionaryBook();
            boolean anyNew = false;
            for (DictionaryEntry ent : saveKeys) {
                if (book.contains(ent)) continue;
                book.add(ent);
                anyNew = true;
            }
            if (anyNew) {
                this.dictionaryReader.saveBook(book);
            }
        }
        catch (ManagedException managedException) {
        }
        finally {
            this.lock.unlock();
        }
    }
}

