/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.dictionary;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import ee.datel.dogis.dictionary.DictionaryEntry;
import ee.datel.dogis.dictionary.DictionaryProvider;
import ee.datel.dogis.dictionary.DictionaryReader;
import ee.datel.dogis.dictionary.DictionaryTranslated;
import ee.datel.dogis.exception.HttpStatusException;
import ee.datel.dogis.exception.ManagedException;
import ee.datel.dogis.utils.CommonUtils;
import ee.datel.dogis.utils.DogisUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;

public abstract class DictionaryProviderCommon
implements DictionaryProvider {
    private final Logger logger = LoggerFactory.getLogger(DictionaryProviderCommon.class);
    private final DictionaryReader dictionaryReader;
    protected final AtomicReference<Set<DictionaryEntry>> newKeys = new AtomicReference(new ConcurrentSkipListSet());
    protected final AtomicReference<Set<DictionaryEntry>> lastBook = new AtomicReference();
    protected final Cache<String, Set<DictionaryTranslated>> translateCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    protected final Cache<String, Map<String, String>> dictionaryCache = CacheBuilder.newBuilder().expireAfterWrite(12L, TimeUnit.HOURS).build();

    protected DictionaryProviderCommon(DictionaryReader dictionaryReader) {
        this.dictionaryReader = dictionaryReader;
    }

    @Override
    public String translate(String key, String language) {
        try {
            return this.getTranslatedValue(key, this.getBook(language).get(key), language);
        }
        catch (HttpStatusException ex) {
            return key.split("\\.")[1];
        }
    }

    @Override
    public Set<DictionaryTranslated> translate(String[] keys, String language) throws HttpStatusException {
        String cachekey = CommonUtils.concatenate((CharSequence[])new CharSequence[]{language, "->", Integer.toString(keys.length), "#", Integer.toString(Arrays.hashCode(keys))});
        try {
            return (Set)this.translateCache.get((Object)cachekey, () -> this.translateArray(keys, language));
        }
        catch (ExecutionException ex) {
            throw (HttpStatusException)ex.getCause();
        }
    }

    protected Set<DictionaryTranslated> translateArray(String[] keys, String language) throws HttpStatusException, InterruptedException, ExecutionException {
        Map<String, String> book = this.getBook(language);
        return (Set)((ForkJoinTask)CommonUtils.getExecutor().submit(() -> ((Stream)Arrays.stream(keys).parallel()).map(key -> new DictionaryTranslated((String)key, this.getTranslatedValue((String)key, (String)book.get(key), language))).collect(Collectors.toSet()))).get();
    }

    protected String getTranslatedValue(String key, String translated, String language) {
        return StringUtils.isBlank((CharSequence)translated) ? this.addNewKey(key, language) : translated;
    }

    protected Map<String, String> getBook(String language) throws HttpStatusException {
        try {
            Set<DictionaryEntry> last = this.lastBook.get();
            Set<DictionaryEntry> book = this.dictionaryReader.getDictionaryBook();
            if (last != book && this.lastBook.compareAndSet(last, book)) {
                this.dictionaryCache.invalidateAll();
                this.translateCache.invalidateAll();
            }
            return this.getDictionaryForLanguage(book, language);
        }
        catch (ManagedException ex) {
            throw new HttpStatusException((HttpStatusCode)HttpStatus.SERVICE_UNAVAILABLE, ex.getMessage());
        }
    }

    protected Map<String, String> getDictionaryForLanguage(Set<DictionaryEntry> book, String language) {
        String defaultLang = DogisUtils.defaultLocale().getLanguage();
        try {
            return (Map)this.dictionaryCache.get((Object)language, () -> {
                Stream<DictionaryEntry> forDefault = book.stream().filter(dic -> defaultLang.equals(dic.language()));
                Stream<DictionaryEntry> translates = defaultLang.equals(language) ? forDefault : Stream.concat(forDefault, book.stream().filter(dic -> language.equals(dic.language())));
                return translates.collect(Collectors.toMap(DictionaryEntry::key, DictionaryEntry::translated, (p, q) -> q));
            });
        }
        catch (ExecutionException ex) {
            return Collections.emptyMap();
        }
    }

    protected String addNewKey(String key, String language) {
        CompletableFuture.runAsync(() -> {
            DictionaryEntry ent = new DictionaryEntry(language, key, null);
            this.newKeys.get().stream().filter(dc -> dc.equals(ent)).findFirst().orElseGet(() -> {
                this.logger.debug("added key: {}", (Object)key);
                this.newKeys.get().add(ent);
                return ent;
            });
        }, CommonUtils.getExecutor());
        return key.substring(key.indexOf(46) + 1);
    }
}

