/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.dictionary;

import ee.datel.dogis.dictionary.DictionaryEntry;
import ee.datel.dogis.exception.ManagedException;
import ee.datel.dogis.exception.ManagedServerException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;

public abstract class DictionaryReader {
    protected final Lock lock = new ReentrantLock();
    public final AtomicReference<Set<DictionaryEntry>> dictionary = new AtomicReference();

    public Set<DictionaryEntry> getDictionaryBook() throws ManagedException {
        this.readDictionaryMetadata();
        Set<DictionaryEntry> book = this.dictionary.get();
        try {
            return book == null ? this.readDictionaryBook() : book;
        }
        catch (ManagedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ManagedServerException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DictionaryEntry> readDictionaryBook() throws ManagedException {
        this.lock.lock();
        try {
            Set<DictionaryEntry> book = this.dictionary.get();
            if (book == null) {
                List<Object> list = this.readDictionaryFromSource();
                book = new TreeSet<DictionaryEntry>(DictionaryEntry.comparingByKey());
                for (Object ent : list) {
                    if (!(ent instanceof Map)) continue;
                    this.parseDictionaryEntry(book, (Map)ent);
                }
                this.dictionary.set(book);
            }
            Set<DictionaryEntry> set = book;
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void readDictionaryMetadata() throws ManagedServerException;

    protected abstract List<Object> readDictionaryFromSource() throws ManagedServerException;

    protected void parseDictionaryEntry(Set<DictionaryEntry> book, Map<String, Object> map) {
        String category = null;
        String entity = null;
        String property = null;
        String telos = null;
        String value = null;
        String language = null;
        String key = null;
        Map trans = null;
        block20: for (Map.Entry<String, Object> entry : map.entrySet()) {
            switch (entry.getKey()) {
                case "category": {
                    category = (String)entry.getValue();
                    continue block20;
                }
                case "entity": {
                    entity = (String)entry.getValue();
                    continue block20;
                }
                case "property": {
                    property = (String)entry.getValue();
                    continue block20;
                }
                case "telos": {
                    telos = (String)entry.getValue();
                    continue block20;
                }
                case "translate": {
                    Object oneValue = entry.getValue();
                    if (oneValue == null) {
                        trans = null;
                        continue block20;
                    }
                    if (oneValue instanceof Map) {
                        Map val;
                        trans = val = (Map)oneValue;
                        continue block20;
                    }
                    value = (String)oneValue;
                    continue block20;
                }
                case "language": {
                    language = (String)entry.getValue();
                    continue block20;
                }
                case "key": {
                    key = (String)entry.getValue();
                    continue block20;
                }
                case "translated": {
                    value = (String)entry.getValue();
                    continue block20;
                }
            }
        }
        if (StringUtils.isNotBlank(language)) {
            if (StringUtils.countMatches(key, (char)'.') == 3) {
                book.add(new DictionaryEntry(language, key, value));
            }
        } else if (trans != null && !trans.isEmpty() && StringUtils.isNotBlank(category) && StringUtils.isNotBlank(entity) && StringUtils.isNotBlank(property) && StringUtils.isNotBlank((CharSequence)telos)) {
            for (Map.Entry<String, Object> entry : trans.entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)entry.getKey())) continue;
                book.add(new DictionaryEntry(entry.getKey(), category, entity, property, telos, (String)entry.getValue()));
            }
        }
    }
}

