/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.security;

import ee.datel.dogis.utils.CommonUtils;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Set;
import org.owasp.encoder.Encode;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class CorsResponseFilter
extends OncePerRequestFilter
implements Ordered {
    private int order = Integer.MIN_VALUE;
    private static final String METHODSLIST = "GET, POST, OPTIONS, PUT, DELETE";
    private static final Set<String> METHODS = Set.of(CommonUtils.split((String)"GET, POST, OPTIONS, PUT, DELETE", (char)','));

    public int getOrder() {
        return this.order;
    }

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        LoggerFactory.getLogger(CorsResponseFilter.class).info("Cors Response Filter initiated");
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (!METHODS.contains(request.getMethod())) {
            response.sendError(405);
            return;
        }
        String orign = request.getHeader("Origin");
        if (orign != null) {
            response.setHeader("Access-Control-Allow-Origin", Encode.forHtmlContent((String)orign));
            response.setHeader("Access-Control-Allow-Credentials", "true");
            response.setHeader("Vary", "Origin");
            if (HttpMethod.OPTIONS.name().equals(request.getMethod())) {
                if (request.getHeader("Access-Control-Request-Headers") != null) {
                    response.setHeader("Access-Control-Allow-Headers", Encode.forHtmlContent((String)request.getHeader("Access-Control-Request-Headers")));
                }
                if (request.getHeader("Access-Control-Request-Method") != null) {
                    response.setHeader("Access-Control-Allow-Methods", METHODSLIST);
                }
                response.setHeader("Access-Control-Max-Age", "86400");
                response.setStatus(200);
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

