/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.security;

import ee.datel.dogis.exception.StreamBreakerException;
import ee.datel.dogis.security.OrganizationName;
import ee.datel.dogis.security.ResourceAuthority;
import ee.datel.dogis.security.UserAuthority;
import java.net.URI;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@ConditionalOnExpression(value="'${application.authorizer.service.url:}'!=''")
@Service
public class UserAuthorizerApiService {
    private final RestTemplate restTemplate;
    protected final URI authoritiesUrl;
    protected final URI resourcesUrl;
    protected final URI organizationsUrl;
    protected final URI registerUrl;

    protected UserAuthorizerApiService(RestTemplate restTemplate, @Value(value="${application.authorizer.service.url}") String authorizerUrl) {
        this.restTemplate = restTemplate;
        URI uri = URI.create(authorizerUrl + "/").normalize();
        this.authoritiesUrl = uri.resolve("authority/");
        this.resourcesUrl = uri.resolve("secured-resources");
        this.organizationsUrl = uri.resolve("organizations");
        this.registerUrl = uri.resolve("register/");
    }

    public List<UserAuthority> getUserAuthorities(String userId) {
        ResponseEntity response = this.restTemplate.getForEntity(this.authoritiesUrl.resolve(userId), UserAuthority[].class);
        if (response.getStatusCode() == HttpStatus.OK) {
            return this.returnList((UserAuthority[])response.getBody());
        }
        throw new StreamBreakerException(response.getStatusCode().toString());
    }

    public List<ResourceAuthority> getAuthorizedResources() {
        ResponseEntity response = this.restTemplate.getForEntity(this.resourcesUrl, ResourceAuthority[].class);
        if (response.getStatusCode() == HttpStatus.OK) {
            return this.returnList((ResourceAuthority[])response.getBody());
        }
        throw new StreamBreakerException(response.getStatusCode().toString());
    }

    public List<OrganizationName> getOrganizations() {
        ResponseEntity response = this.restTemplate.getForEntity(this.organizationsUrl, OrganizationName[].class);
        if (response.getStatusCode() == HttpStatus.OK) {
            return this.returnList((OrganizationName[])response.getBody());
        }
        throw new StreamBreakerException(response.getStatusCode().toString());
    }

    public void registerSession(String userid, String sessionid) {
        this.registerSession(userid, null, null, sessionid);
    }

    public void registerSession(String userid, String firstName, String lastName, String sessionid) {
        RegistrationInfo info = new RegistrationInfo(firstName, lastName, sessionid);
        URI uri = this.registerUrl.resolve(userid);
        RequestEntity request = RequestEntity.post((URI)uri).contentType(MediaType.APPLICATION_JSON).body((Object)info);
        ResponseEntity response = this.restTemplate.exchange(request, Void.class);
        if (response.getStatusCode() != HttpStatus.ACCEPTED) {
            throw new StreamBreakerException(response.getStatusCode().toString());
        }
    }

    protected <T> List<T> returnList(T[] rest) {
        if (rest.length == 0) {
            return List.of();
        }
        return List.of(rest);
    }

    protected record RegistrationInfo(String firstName, String lastName, String sessionId) {
    }
}

