/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.utils;

import ee.datel.dogis.exception.ManagedServerException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
public class DeployCrypterService {
    protected static final String CRYPTO_TRANSFORMATION = "AES/GCM/NoPadding";
    protected static final int IV_LENGTH = 12;
    protected static final int TAG_LENGTH_BIT = 128;
    private final Logger logger = LoggerFactory.getLogger(DeployCrypterService.class);
    private final SecureRandom secureRandom = new SecureRandom();
    private final Lock lock = new ReentrantLock();
    protected final SecretKeySpec secret;
    protected Cipher cipher;

    protected DeployCrypterService(@Value(value="${application.group.key:}") String theKey) {
        if (StringUtils.isBlank((CharSequence)theKey)) {
            this.logger.warn("Parameter {application.group.key} not provided");
            this.secret = null;
        } else {
            this.secret = new SecretKeySpec(StringUtils.rightPad((String)theKey, (int)32, (char)'%').getBytes(StandardCharsets.US_ASCII), "AES");
            try {
                this.cipher = Cipher.getInstance(CRYPTO_TRANSFORMATION);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public String encrypt(String value) throws ManagedServerException {
        if (this.cipher == null) {
            throw new IllegalStateException(CRYPTO_TRANSFORMATION);
        }
        byte[] iv = this.getInitializationVector();
        byte[] encryptedData = this.encryptText(value, this.secret, new GCMParameterSpec(128, iv));
        return this.responseBase64(iv, encryptedData);
    }

    public String decrypt(String encryptedValue) throws ManagedServerException {
        if (this.cipher == null) {
            throw new IllegalStateException(CRYPTO_TRANSFORMATION);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(Base64.getDecoder().decode(encryptedValue));
        byte ivLength = byteBuffer.get();
        byte[] iv = new byte[ivLength];
        byteBuffer.get(iv);
        byte[] encrypted = new byte[byteBuffer.remaining()];
        byteBuffer.get(encrypted);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        this.lock.lock();
        try {
            this.cipher.init(2, (Key)this.secret, parameterSpec);
            byte[] dec = this.cipher.doFinal(encrypted);
            String string = new String(dec, StandardCharsets.UTF_8);
            return string;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new ManagedServerException(ex.getMessage());
        }
        finally {
            this.lock.unlock();
        }
    }

    protected String responseBase64(byte[] iv, byte[] cipherText) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(13 + cipherText.length).put((byte)12).put(iv).put(cipherText);
        return Base64.getEncoder().encodeToString(byteBuffer.array());
    }

    protected byte[] encryptText(String password, SecretKey key, GCMParameterSpec parameterSpec) throws ManagedServerException {
        this.lock.lock();
        try {
            this.cipher.init(1, (Key)key, parameterSpec);
            byte[] byArray = this.cipher.doFinal(password.getBytes(StandardCharsets.UTF_8));
            return byArray;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new ManagedServerException(ex.getMessage());
        }
        finally {
            this.lock.unlock();
        }
    }

    protected byte[] getInitializationVector() {
        byte[] iv = new byte[12];
        this.secureRandom.nextBytes(iv);
        return iv;
    }
}

