/*
 * Decompiled with CFR 0.152.
 */
package ee.datel.dogis.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import ee.datel.dogis.exception.JsonException;
import ee.datel.dogis.utils.CommonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormatSymbols;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class DogisUtils {
    private static final AtomicReference<Locale> THISLOCALE = new AtomicReference<Locale>(Locale.ENGLISH);
    private final Logger logger = LoggerFactory.getLogger(DogisUtils.class);
    private final Set<String> languages;
    private final RestTemplate restTemplate;
    private ObjectMapper jacksonMapper;
    private Map<String, Locale> locales;

    public static Locale defaultLocale() {
        return THISLOCALE.get();
    }

    public static void setThis(Locale locale) {
        THISLOCALE.set(locale);
    }

    protected DogisUtils(Jackson2ObjectMapperBuilder jacksonBuilder, RestTemplate restTemplate, @Value(value="${application.proxy.configuration.languages:}") String languages) {
        this.restTemplate = restTemplate;
        this.languages = this.initLanguages(languages);
        this.jacksonMapper = jacksonBuilder.build();
        this.jacksonMapper.registerModule((Module)new JavaTimeModule());
    }

    public Set<String> initLanguages(String languages) {
        String[] langs = CommonUtils.split((String)languages, (char)',');
        if (langs.length == 0) {
            langs = new String[]{Locale.ENGLISH.getLanguage()};
        }
        this.locales = Arrays.stream(langs).map(Locale::new).collect(Collectors.toMap(Locale::getLanguage, m -> m));
        DogisUtils.setThis(this.locales.get(langs[0]));
        return Set.copyOf(this.locales.keySet());
    }

    public static long getCrc32(InputStream in) throws IOException {
        return DogisUtils.getCrc32(in, null);
    }

    public static long getCrc32(InputStream in, OutputStream out) throws IOException {
        CheckedInputStream check = new CheckedInputStream(in, new CRC32());
        byte[] buff = new byte[8192];
        int len = 0;
        while ((len = check.read(buff)) != -1) {
            if (out == null) continue;
            out.write(buff, 0, len);
        }
        return check.getChecksum().getValue();
    }

    public String[] getMonths() {
        DateFormatSymbols sdf = DateFormatSymbols.getInstance(LocaleContextHolder.getLocale());
        String[] arr = sdf.getMonths();
        return arr.length > 12 ? Arrays.copyOf(arr, 12) : arr;
    }

    public Set<String> getLanguages() {
        return this.languages;
    }

    public Locale getLocale(String language) {
        return this.locales.computeIfAbsent(language, Locale::new);
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public ObjectMapper getObjectMapper() {
        return this.jacksonMapper;
    }

    public String jsonData(Object data) throws JsonException {
        try {
            return this.getObjectMapper().writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            this.logger.warn("Object to JSON parse error {}\n{}", (Object)e.getMessage(), (Object)data.getClass().getName());
            throw new JsonException(e.getMessage());
        }
    }
}

