package ee.datel.dogis6.service;

/*-
 * ==========================LICENSE_START===================================
 * ee.datel.dogis6:dogis6-auth
 *  
 * Copyright (C) 2022 AS Datel <licenses@datel.ee>
 *  
 * Redistribution and use in binary form, without modification, are permitted
 * provided that the following conditions are met:
 *
 * 1. Redistributions must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution.
 *
 * 2. Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from this
 * software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ===========================LICENSE_END====================================
 */

import ee.datel.dogis6.model.OrganizationName;
import ee.datel.dogis6.model.RegistrationInfo;
import ee.datel.dogis6.model.ResourceAuthority;
import ee.datel.dogis6.model.UserAuthority;

import java.util.List;

public interface AuthDataService {
  /**
   * Returns list of all secured resources.
   *
   * @return list of secured resources
   */
  List<ResourceAuthority> getManagedResources();

  /**
   * Returns list of all organizations.
   *
   * @return list of all organizations
   */
  List<OrganizationName> getOrganizations();

  /**
   * Returns list of user's authorities.
   *
   * @param userId user identification
   * @return list of user's authorities
   */
  List<UserAuthority> getUserAuthorities(String userId);

  /**
   * Registers user session id and when needed registers new user.
   * <p>
   * <i>Optional method. Default implementation does nothing.</i>
   * </p>
   *
   * @param userId user identification
   * @param registration data
   */
  default void registerUserSession(String userId, RegistrationInfo registration) {}

}
