/*
 * Decompiled with CFR 0.152.
 */
package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.telenordigital.nbiot.Device;
import com.telenordigital.nbiot.OutputDataMessageInternal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
final class ImmutableOutputDataMessageInternal
implements OutputDataMessageInternal {
    private final String type;
    @Nullable
    private final Device device;
    @Nullable
    private final byte[] payload;
    @Nullable
    private final Long received;

    private ImmutableOutputDataMessageInternal(String type, @Nullable Device device, @Nullable byte[] payload, @Nullable Long received) {
        this.type = type;
        this.device = device;
        this.payload = payload;
        this.received = received;
    }

    @Override
    @JsonProperty(value="type")
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="device")
    @Nullable
    public Device device() {
        return this.device;
    }

    @Override
    @JsonProperty(value="payload")
    @Nullable
    public byte[] payload() {
        return this.payload;
    }

    @Override
    @JsonProperty(value="received")
    @Nullable
    public Long received() {
        return this.received;
    }

    public final ImmutableOutputDataMessageInternal withType(String value) {
        if (this.type.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "type");
        return new ImmutableOutputDataMessageInternal(newValue, this.device, this.payload, this.received);
    }

    public final ImmutableOutputDataMessageInternal withDevice(@Nullable Device value) {
        if (this.device == value) {
            return this;
        }
        return new ImmutableOutputDataMessageInternal(this.type, value, this.payload, this.received);
    }

    public final ImmutableOutputDataMessageInternal withPayload(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return new ImmutableOutputDataMessageInternal(this.type, this.device, newValue, this.received);
    }

    public final ImmutableOutputDataMessageInternal withReceived(@Nullable Long value) {
        if (Objects.equals(this.received, value)) {
            return this;
        }
        return new ImmutableOutputDataMessageInternal(this.type, this.device, this.payload, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOutputDataMessageInternal && this.equalTo((ImmutableOutputDataMessageInternal)another);
    }

    private boolean equalTo(ImmutableOutputDataMessageInternal another) {
        return this.type.equals(another.type) && Objects.equals(this.device, another.device) && Arrays.equals(this.payload, another.payload) && Objects.equals(this.received, another.received);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.device);
        h += (h << 5) + Arrays.hashCode(this.payload);
        h += (h << 5) + Objects.hashCode(this.received);
        return h;
    }

    public String toString() {
        return "OutputDataMessageInternal{type=" + this.type + ", device=" + this.device + ", payload=" + Arrays.toString(this.payload) + ", received=" + this.received + "}";
    }

    public static ImmutableOutputDataMessageInternal copyOf(OutputDataMessageInternal instance) {
        if (instance instanceof ImmutableOutputDataMessageInternal) {
            return (ImmutableOutputDataMessageInternal)instance;
        }
        return new Builder().from(instance).build();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private String type;
        @Nullable
        private Device device;
        @Nullable
        private byte[] payload;
        @Nullable
        private Long received;

        public final Builder from(OutputDataMessageInternal instance) {
            Long receivedValue;
            byte[] payloadValue;
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            Device deviceValue = instance.device();
            if (deviceValue != null) {
                this.device(deviceValue);
            }
            if ((payloadValue = instance.payload()) != null) {
                this.payload(payloadValue);
            }
            if ((receivedValue = instance.received()) != null) {
                this.received(receivedValue);
            }
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="device")
        public final Builder device(@Nullable Device device) {
            this.device = device;
            return this;
        }

        @JsonProperty(value="payload")
        public final Builder payload(byte ... payload) {
            this.payload = payload;
            return this;
        }

        @JsonProperty(value="received")
        public final Builder received(@Nullable Long received) {
            this.received = received;
            return this;
        }

        public ImmutableOutputDataMessageInternal build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOutputDataMessageInternal(this.type, this.device, this.payload, this.received);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build OutputDataMessageInternal, some of required attributes are not set " + attributes;
        }
    }
}

