/*
 * Decompiled with CFR 0.152.
 */
package eu.agrosense.server.activityfield;

import eu.agrosense.api.activityfield.ActivityFieldConstants;
import eu.agrosense.api.session.Session;
import eu.agrosense.server.BaseSessionAction;
import eu.agrosense.server.storage.api.StorageService;
import eu.agrosense.shared.model.ItemIdType;
import eu.agrosense.shared.model.PM;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendolphin.core.PresentationModel;
import org.opendolphin.core.comm.Command;
import org.opendolphin.core.comm.DataCommand;
import org.opendolphin.core.comm.NamedCommand;
import org.opendolphin.core.server.DTO;
import org.opendolphin.core.server.ServerPresentationModel;
import org.opendolphin.core.server.comm.ActionRegistry;
import org.opendolphin.core.server.comm.CommandHandler;
import org.opendolphin.core.server.comm.NamedCommandHandler;

public class PullActivityFieldListAction
extends BaseSessionAction {
    private static final String[] MINIMAL_ATTRS = new String[]{"URI", "name", "geometry"};
    private static final String[] ALL_ATTRS = new String[]{"URI", "name", "description", "farm_URI", "fieldURI", "activityURI", "geometry", "boundingBox", "areaInHectares", "averageValue", "defaultValue"};

    public void registerIn(ActionRegistry registry) {
        super.registerIn(registry);
        registry.register(ActivityFieldConstants.CMD_PULL_ACTIVITY_FIELD_LIST, (CommandHandler)new DataListHandler(MINIMAL_ATTRS));
        registry.register(ActivityFieldConstants.CMD_PULL_ACTIVITY_FIELD_LIST_COMPLETE, (CommandHandler)new DataListHandler(ALL_ATTRS));
        registry.register(ActivityFieldConstants.CMD_PULL_PM_FOR_CURRENT_ACTIVITY_FIELD, (CommandHandler)new NamedCommandHandler(){

            public void handleCommand(NamedCommand command, List<Command> response) {
                ServerPresentationModel currentActivityFieldModel = PullActivityFieldListAction.this.getServerDolphin().getAt(ActivityFieldConstants.ID_CURRENT_ACTIVITY_FIELD);
                String uri = PM.getURIString((PresentationModel)currentActivityFieldModel);
                StorageService service = StorageService.Locator.locateForSession((Session)PullActivityFieldListAction.this.session);
                DTO dto = service.findDTOById(uri);
                if (dto != null) {
                    PullActivityFieldListAction.this.presentationModel(uri, ItemIdType.AFD.name(), dto);
                }
            }
        });
    }

    class DataListHandler
    implements NamedCommandHandler {
        private final String[] attrs;

        public DataListHandler(String[] attrs) {
            this.attrs = attrs;
        }

        public void handleCommand(NamedCommand command, List<Command> response) {
            StorageService service = StorageService.Locator.locateForSession((Session)PullActivityFieldListAction.this.session);
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            queryParams.put("item_id_type", ItemIdType.AFD.name());
            PullActivityFieldListAction.this.addFarmFilter(queryParams);
            this.addCurrentIdFilter(queryParams);
            Set result = service.findDataByExample(queryParams, this.attrs);
            for (Map data : result) {
                response.add((Command)new DataCommand(data));
            }
        }

        private void addCurrentIdFilter(Map<String, Object> queryParams) {
            ServerPresentationModel currentActivityField = PullActivityFieldListAction.this.getServerDolphin().getAt(ActivityFieldConstants.ID_CURRENT_ACTIVITY_FIELD);
            String currentActivityFieldId = PM.getURIString((PresentationModel)currentActivityField);
            if (currentActivityFieldId != null) {
                queryParams.put("URI", currentActivityFieldId);
            }
        }
    }
}

