/*
 *    Copyright 2017-2019 Frederic Thevenet
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package eu.binjr.sources.csv.adapters;

import eu.binjr.core.data.adapters.BaseDataAdapterInfo;
import eu.binjr.core.preferences.AppEnvironment;

/**
 * Defines the metadata associated with the CsvFileDataAdapter.
 *
 * @author Frederic Thevenet
 */
public class CsvFileDataAdapterInfo extends BaseDataAdapterInfo {

    /**
     * Initialises a new instance of the {@link CsvFileDataAdapterInfo} class.
     */
    public CsvFileDataAdapterInfo() {
        super("CSV File",
                "CSV File Data Adapter",
                AppEnvironment.COPYRIGHT_NOTICE,
                AppEnvironment.LICENSE,
                AppEnvironment.HTTP_WWW_BINJR_EU,
                CsvFileAdapter.class,
                CsvFileAdapterDialog.class);
    }
}
