/*
 * Decompiled with CFR 0.152.
 */
package eu.binjr.sources.rrd4j.adapters;

import eu.binjr.core.data.adapters.BaseDataAdapter;
import eu.binjr.core.data.adapters.DataAdapter;
import eu.binjr.core.data.adapters.TimeSeriesBinding;
import eu.binjr.core.data.exceptions.DataAdapterException;
import eu.binjr.core.data.exceptions.FetchingDataFromAdapterException;
import eu.binjr.core.data.timeseries.DoubleTimeSeriesProcessor;
import eu.binjr.core.data.timeseries.TimeSeriesProcessor;
import eu.binjr.core.data.workspace.ChartType;
import eu.binjr.core.data.workspace.TimeSeriesInfo;
import eu.binjr.core.data.workspace.UnitPrefixes;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.chart.XYChart;
import javafx.scene.control.TreeItem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.FetchRequest;
import org.rrd4j.core.InvalidRrdException;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdNioBackendFactory;

public class Rrd4jFileAdapter
extends BaseDataAdapter<Double> {
    private static final Logger logger;
    private final Map<Path, RrdDb> rrdDbMap = new HashMap<Path, RrdDb>();
    private List<Path> rrdPaths;
    private List<Path> tempPathToCollect = new ArrayList<Path>();

    public Rrd4jFileAdapter() {
        this(new ArrayList<Path>());
    }

    public Rrd4jFileAdapter(List<Path> rrdPath) {
        this.rrdPaths = rrdPath;
    }

    public TreeItem<TimeSeriesBinding<Double>> getBindingTree() throws DataAdapterException {
        TreeItem tree = new TreeItem((Object)new TimeSeriesBinding("", "/", null, this.getSourceName(), UnitPrefixes.METRIC, ChartType.STACKED, "-", "/" + this.getSourceName(), (DataAdapter)this));
        for (Path rrdPath : this.rrdPaths) {
            try {
                String rrdFileName = rrdPath.getFileName().toString();
                TreeItem rrdNode = new TreeItem((Object)new TimeSeriesBinding(rrdFileName, rrdFileName, null, rrdFileName, UnitPrefixes.METRIC, ChartType.STACKED, "-", ((TimeSeriesBinding)tree.getValue()).getTreeHierarchy() + "/" + rrdFileName, (DataAdapter)this));
                RrdDb rrd = this.openRrdDb(rrdPath);
                this.rrdDbMap.put(rrdPath, rrd);
                for (ConsolFun consolFun : Arrays.stream(rrd.getRrdDef().getArcDefs()).map(ArcDef::getConsolFun).collect(Collectors.toSet())) {
                    TreeItem consolFunNode = new TreeItem((Object)new TimeSeriesBinding(consolFun.toString(), rrdPath.resolve(consolFun.toString()).toString(), null, consolFun.toString(), UnitPrefixes.METRIC, ChartType.STACKED, "-", ((TimeSeriesBinding)rrdNode.getValue()).getTreeHierarchy() + "/" + consolFun.toString(), (DataAdapter)this));
                    rrdNode.getChildren().add((Object)consolFunNode);
                    for (String ds : rrd.getDsNames()) {
                        consolFunNode.getChildren().add((Object)new TreeItem((Object)new TimeSeriesBinding(ds, ((TimeSeriesBinding)consolFunNode.getValue()).getPath(), null, ds, UnitPrefixes.METRIC, ChartType.STACKED, "-", ((TimeSeriesBinding)consolFunNode.getValue()).getTreeHierarchy() + "/" + ds, (DataAdapter)this)));
                    }
                }
                tree.getChildren().add((Object)rrdNode);
            }
            catch (IOException e) {
                throw new DataAdapterException("Failed to open rrd db", (Throwable)e);
            }
        }
        return tree;
    }

    public Map<TimeSeriesInfo<Double>, TimeSeriesProcessor<Double>> fetchData(String path, Instant begin, Instant end, List<TimeSeriesInfo<Double>> seriesInfo, boolean bypassCache) throws DataAdapterException {
        if (this.isClosed()) {
            throw new IllegalStateException("An attempt was made to fetch data from a closed adapter");
        }
        Path dsPath = Path.of(path, new String[0]);
        try {
            FetchRequest request = this.rrdDbMap.get(dsPath.getParent()).createFetchRequest(ConsolFun.valueOf((String)dsPath.getFileName().toString()), begin.getEpochSecond(), end.getEpochSecond());
            request.setFilter((String[])seriesInfo.stream().map(s -> s.getBinding().getLabel()).toArray(String[]::new));
            FetchData data = request.fetchData();
            HashMap<TimeSeriesInfo<Double>, TimeSeriesProcessor<Double>> series = new HashMap<TimeSeriesInfo<Double>, TimeSeriesProcessor<Double>>();
            for (int i = 0; i < data.getRowCount(); ++i) {
                ZonedDateTime timeStamp = Instant.ofEpochSecond(data.getTimestamps()[i]).atZone(this.getTimeZoneId());
                for (TimeSeriesInfo<Double> info : seriesInfo) {
                    Double val = data.getValues(info.getBinding().getLabel())[i];
                    XYChart.Data point = new XYChart.Data((Object)timeStamp, (Object)(val.isNaN() ? 0.0 : val));
                    TimeSeriesProcessor seriesProcessor = series.computeIfAbsent(info, k -> new DoubleTimeSeriesProcessor());
                    seriesProcessor.addSample(point);
                }
            }
            logger.trace(() -> String.format("Built %d series with %d samples each (%d total samples)", seriesInfo.size(), data.getRowCount(), seriesInfo.size() * data.getRowCount()));
            return series;
        }
        catch (IOException e) {
            throw new FetchingDataFromAdapterException("IO Error while retrieving data from rrd db", (Throwable)e);
        }
    }

    public String getEncoding() {
        return "UTF-8";
    }

    public ZoneId getTimeZoneId() {
        return ZoneId.systemDefault();
    }

    public String getSourceName() {
        return "[RRD] " + this.rrdPaths.get(0).getFileName() + (String)(this.rrdPaths.size() > 1 ? " + " + (this.rrdPaths.size() - 1) + " more RRD file(s)" : "");
    }

    public Map<String, String> getParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        int i = 0;
        for (Path rrdPath : this.rrdPaths) {
            params.put("rrdPaths_" + i++, rrdPath.toString());
        }
        return params;
    }

    public void loadParams(Map<String, String> params) throws DataAdapterException {
        this.rrdPaths = params.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("rrdPaths_")).map(e -> Paths.get((String)e.getValue(), new String[0])).collect(Collectors.toList());
    }

    public void close() {
        this.closeRrdDb();
        this.cleanTempFiles();
        super.close();
    }

    private RrdDb openRrdDb(Path rrdPath) throws IOException {
        if ("text/xml".equalsIgnoreCase(Files.probeContentType(rrdPath))) {
            logger.debug(() -> "Attempting to import as an rrd XML dump");
            Path temp = Files.createTempFile("binjr_", "_imported.rrd", new FileAttribute[0]);
            this.tempPathToCollect.add(temp);
            return new RrdDb(temp.toUri(), "xml:/" + rrdPath.toString());
        }
        try {
            return new RrdDb(rrdPath.toUri());
        }
        catch (InvalidRrdException e) {
            logger.debug(() -> "Failed to open " + rrdPath + " as an Rrd4j db: attempting to import as an rrdTool db");
            Path temp = Files.createTempFile("binjr_", "_imported.rrd", new FileAttribute[0]);
            this.tempPathToCollect.add(temp);
            return new RrdDb(temp.toUri(), "rrdtool:/" + rrdPath.toString());
        }
    }

    private void closeRrdDb() {
        this.rrdDbMap.forEach((s, rrdDb) -> {
            logger.debug(() -> "Closing RRD db " + s);
            try {
                rrdDb.close();
            }
            catch (IOException e) {
                logger.error("Error attempting to close RRD db " + s, (Throwable)e);
            }
        });
        this.rrdDbMap.clear();
    }

    private void cleanTempFiles() {
        this.tempPathToCollect.forEach(p -> {
            logger.debug(() -> "Deleting temp file " + p);
            try {
                Files.delete(p);
            }
            catch (IOException e) {
                logger.error("Failed to delete temp file", (Throwable)e);
            }
        });
        this.tempPathToCollect.clear();
    }

    static {
        RrdBackendFactory.setActiveFactories((RrdBackendFactory[])new RrdBackendFactory[]{new RrdNioBackendFactory(0)});
        logger = LogManager.getLogger(Rrd4jFileAdapter.class);
    }
}

