/*
 * Decompiled with CFR 0.152.
 */
package eu.binjr.sources.rrd4j.adapters;

import eu.binjr.core.data.adapters.DataAdapter;
import eu.binjr.core.data.exceptions.CannotInitializeDataAdapterException;
import eu.binjr.core.data.exceptions.DataAdapterException;
import eu.binjr.core.dialogs.Dialogs;
import eu.binjr.core.preferences.GlobalPreferences;
import eu.binjr.sources.rrd4j.adapters.Rrd4jFileAdapter;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Rrd4jFileAdapterDialog
extends Dialog<DataAdapter> {
    private static final Logger logger = LogManager.getLogger(Rrd4jFileAdapterDialog.class);
    private static final String BINJR_SOURCES = "binjr/sources";
    private DataAdapter result = null;
    private final TextField pathsField;

    public Rrd4jFileAdapterDialog(Node owner) {
        if (owner != null) {
            this.initOwner((Window)Dialogs.getStage((Node)owner));
        }
        this.setTitle("Source");
        Button browseButton = new Button("Browse");
        this.pathsField = new TextField();
        HBox pathHBox = new HBox();
        pathHBox.setSpacing(10.0);
        pathHBox.setAlignment(Pos.CENTER);
        pathHBox.getChildren().addAll((Object[])new Node[]{this.pathsField, browseButton});
        browseButton.setPrefWidth(-1.0);
        this.pathsField.setPrefWidth(400.0);
        DialogPane dialogPane = new DialogPane();
        dialogPane.setHeaderText("Add RRD file(s)");
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        dialogPane.setGraphic((Node)new Region());
        dialogPane.getGraphic().getStyleClass().addAll((Object[])new String[]{"source-icon", "dialog-icon"});
        dialogPane.setContent((Node)pathHBox);
        this.setDialogPane(dialogPane);
        browseButton.setOnAction(event -> {
            File selectedFile = this.displayFileChooser((Node)event.getSource());
            if (selectedFile != null) {
                this.pathsField.setText(selectedFile.getPath());
            }
        });
        Button okButton = (Button)dialogPane.lookupButton(ButtonType.OK);
        Platform.runLater(() -> ((TextField)this.pathsField).requestFocus());
        okButton.addEventFilter(ActionEvent.ACTION, ae -> {
            try {
                this.result = this.getDataAdapter();
            }
            catch (CannotInitializeDataAdapterException e) {
                Dialogs.notifyError((String)"Error initializing adapter to source", (Throwable)e, (Pos)Pos.CENTER, (Node)this.pathsField);
                ae.consume();
            }
            catch (DataAdapterException e) {
                Dialogs.notifyError((String)"Error with the adapter to source", (Throwable)e, (Pos)Pos.CENTER, (Node)this.pathsField);
                ae.consume();
            }
            catch (Throwable e) {
                Dialogs.notifyError((String)"Unexpected error while retrieving data adapter", (Throwable)e, (Pos)Pos.CENTER, (Node)this.pathsField);
                ae.consume();
            }
        });
        this.setResultConverter(dialogButton -> {
            ButtonBar.ButtonData data;
            ButtonBar.ButtonData buttonData = data = dialogButton == null ? null : dialogButton.getButtonData();
            if (data == ButtonBar.ButtonData.OK_DONE) {
                return this.result;
            }
            return null;
        });
    }

    private File displayFileChooser(Node owner) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Open Rrd4j File(s)");
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("RRD binary files", new String[]{"*.rrd"}));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("RRD XML dumps", new String[]{"*.xml"}));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("All files", new String[]{"*.*"}));
        fileChooser.setInitialDirectory(GlobalPreferences.getInstance().getMostRecentSaveFolder().toFile());
        List rrdFiles = fileChooser.showOpenMultipleDialog((Window)Dialogs.getStage((Node)owner));
        if (rrdFiles != null) {
            this.pathsField.setText(rrdFiles.stream().map(File::getPath).collect(Collectors.joining(";")));
        }
        return null;
    }

    private DataAdapter<?> getDataAdapter() throws DataAdapterException {
        List<Path> rrdFiles = Arrays.stream(this.pathsField.getText().split(";")).map(s -> Paths.get(s, new String[0])).collect(Collectors.toList());
        rrdFiles.stream().findFirst().ifPresent(path -> GlobalPreferences.getInstance().setMostRecentSaveFolder(path.getParent()));
        return new Rrd4jFileAdapter(rrdFiles);
    }
}

