/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.sftp;

import eu.cloudnetservice.common.log.LogManager;
import eu.cloudnetservice.common.log.Logger;
import java.io.Closeable;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import lombok.NonNull;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.SessionFactory;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPEngine;

public class SFTPClientPool
implements Closeable {
    private static final Logger LOGGER = LogManager.logger(SFTPClientPool.class);
    private final int maxClients;
    private final Callable<SSHClient> clientFactory;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private final AtomicInteger createdClients = new AtomicInteger();
    private final ReentrantLock clientCreateLock = new ReentrantLock();
    private final Queue<SFTPClientWrapper> pooledClients = new LinkedList<SFTPClientWrapper>();
    private final Queue<CompletableFuture<SFTPClientWrapper>> clientReturnWaiters = new LinkedList<CompletableFuture<SFTPClientWrapper>>();

    public SFTPClientPool(int maxClients, @NonNull Callable<SSHClient> clientFactory) {
        if (clientFactory == null) {
            throw new NullPointerException("clientFactory is marked non-null but is null");
        }
        this.maxClients = maxClients;
        this.clientFactory = clientFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public SFTPClientWrapper takeClient() {
        this.clientCreateLock.lock();
        this.checkClosed();
        SFTPClientWrapper client = this.pooledClients.poll();
        if (client != null) {
            if (client.getSFTPEngine().getSubsystem().isOpen()) {
                SFTPClientWrapper sFTPClientWrapper = client;
                return sFTPClientWrapper;
            }
            client.doClose();
            this.createdClients.decrementAndGet();
        }
        if (this.createdClients.get() < this.maxClients) {
            try {
                SFTPClientWrapper sFTPClientWrapper = this.createAndRegisterClient();
                return sFTPClientWrapper;
            }
            catch (Exception exception) {
                throw new IllegalStateException("Unable to open new session", exception);
            }
        }
        CompletableFuture future = new CompletableFuture();
        this.clientReturnWaiters.add(future);
        SFTPClientWrapper sFTPClientWrapper = (SFTPClientWrapper)((Object)future.join());
        return sFTPClientWrapper;
        finally {
            this.clientCreateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void returnClient(@NonNull SFTPClientWrapper client) {
        block12: {
            if (client == null) {
                throw new NullPointerException("client is marked non-null but is null");
            }
            try {
                this.clientCreateLock.lock();
                if (!this.open.get()) {
                    client.doClose();
                    return;
                }
                waitingCreateFuture = this.clientReturnWaiters.poll();
                if (client.getSFTPEngine().getSubsystem().isOpen()) {
                    if (waitingCreateFuture != null) {
                        waitingCreateFuture.complete(client);
                    } else {
                        this.pooledClients.add(client);
                    }
                    break block12;
                }
                client.doClose();
                if (waitingCreateFuture == null) ** GOTO lbl26
                try {
                    waitingCreateFuture.complete(this.createAndRegisterClient());
                    return;
                }
                catch (Exception exception) {
                    SFTPClientPool.LOGGER.severe("Unable to create new client to deliver waiting promise", (Throwable)exception, new Object[0]);
lbl26:
                    // 2 sources

                    this.createdClients.decrementAndGet();
                }
            }
            finally {
                this.clientCreateLock.unlock();
            }
        }
    }

    public boolean stillActive() {
        return this.open.get();
    }

    @NonNull
    private SFTPClientWrapper createAndRegisterClient() throws Exception {
        SFTPClientWrapper client = new SFTPClientWrapper(new SFTPEngine((SessionFactory)this.clientFactory.call()).init());
        this.createdClients.incrementAndGet();
        return client;
    }

    private void checkClosed() {
        if (!this.open.get()) {
            throw new IllegalStateException("pool closed");
        }
    }

    @Override
    public void close() {
        if (this.open.compareAndSet(true, false)) {
            SFTPClientWrapper client;
            CompletableFuture<SFTPClientWrapper> future;
            while ((future = this.clientReturnWaiters.poll()) != null) {
                future.cancel(true);
            }
            while ((client = this.pooledClients.poll()) != null) {
                client.doClose();
            }
            this.createdClients.set(0);
        }
    }

    public final class SFTPClientWrapper
    extends SFTPClient {
        public SFTPClientWrapper(SFTPEngine engine) {
            super(engine);
            if (engine == null) {
                throw new NullPointerException("engine is marked non-null but is null");
            }
        }

        public void close() {
            SFTPClientPool.this.returnClient(this);
        }

        public void doClose() {
            try {
                super.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

