/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.sftp;

import eu.cloudnetservice.common.io.FileUtil;
import eu.cloudnetservice.common.io.ZipUtil;
import eu.cloudnetservice.common.log.LogManager;
import eu.cloudnetservice.common.log.Logger;
import eu.cloudnetservice.driver.service.ServiceTemplate;
import eu.cloudnetservice.driver.template.FileInfo;
import eu.cloudnetservice.driver.template.TemplateStorage;
import eu.cloudnetservice.modules.sftp.NopLoggerFactory;
import eu.cloudnetservice.modules.sftp.SFTPClientPool;
import eu.cloudnetservice.modules.sftp.config.SFTPTemplateStorageConfig;
import eu.cloudnetservice.modules.sftp.sshj.ActiveHeartbeatKeepAliveProvider;
import eu.cloudnetservice.modules.sftp.sshj.FilteringLocalFileSource;
import io.vavr.CheckedFunction1;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import lombok.NonNull;
import net.schmizz.sshj.Config;
import net.schmizz.sshj.DefaultConfig;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalDestFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.jetbrains.annotations.Nullable;

public class SFTPTemplateStorage
implements TemplateStorage {
    protected static final String REMOTE_DIR_FORMAT = "%s/%s/%s";
    protected static final Logger LOGGER = LogManager.logger(SFTPTemplateStorage.class);
    private final Config config;
    private final SFTPClientPool pool;
    private final SFTPTemplateStorageConfig storageConfig;
    private volatile SSHClient sshClient;

    public SFTPTemplateStorage(@NonNull SFTPTemplateStorageConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.storageConfig = config;
        this.config = new DefaultConfig();
        this.config.setLoggerFactory(NopLoggerFactory.INSTANCE);
        this.config.setKeepAliveProvider(ActiveHeartbeatKeepAliveProvider.INSTANCE);
        this.pool = new SFTPClientPool(config.clientPoolSize(), () -> {
            SSHClient client = this.sshClient;
            if (client != null) {
                if (client.isConnected() && client.isAuthenticated()) {
                    return client;
                }
                client.disconnect();
                this.sshClient = null;
            }
            this.sshClient = new SSHClient(this.config);
            this.sshClient.setConnectTimeout(5000);
            this.sshClient.setRemoteCharset(StandardCharsets.UTF_8);
            Path knownHosts = config.knownHostFile();
            if (knownHosts == null) {
                this.sshClient.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            } else {
                this.sshClient.loadKnownHosts(knownHosts.toFile());
            }
            this.sshClient.connect(config.address().host(), config.address().port());
            if (config.sshKeyPath() != null) {
                this.sshClient.authPublickey(config.username(), new KeyProvider[]{this.sshClient.loadKeys(config.sshKeyPath().toString(), config.sshKeyPassword())});
            } else {
                this.sshClient.authPassword(config.username(), config.password());
            }
            return this.sshClient;
        });
    }

    @NonNull
    public String name() {
        return this.storageConfig.storage();
    }

    public boolean deployDirectory(@NonNull ServiceTemplate target, @NonNull Path directory, @Nullable Predicate<Path> filter) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (directory == null) {
            throw new NullPointerException("directory is marked non-null but is null");
        }
        return this.executeWithClient((CheckedFunction1 & Serializable)client -> {
            client.put((LocalSourceFile)new FilteringLocalFileSource(directory, filter), this.constructRemotePath(target, new String[0]));
            return true;
        }, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deploy(@NonNull ServiceTemplate target, @NonNull InputStream inputStream) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        Path temp = ZipUtil.extract((InputStream)inputStream, (Path)FileUtil.createTempFile());
        if (temp != null) {
            try {
                boolean bl = this.deployDirectory(target, temp, null);
                return bl;
            }
            finally {
                FileUtil.delete((Path)temp);
            }
        }
        return false;
    }

    public boolean pull(@NonNull ServiceTemplate template, @NonNull Path directory) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (directory == null) {
            throw new NullPointerException("directory is marked non-null but is null");
        }
        return this.executeWithClient((CheckedFunction1 & Serializable)client -> {
            FileSystemFile target = new FileSystemFile(directory.toFile());
            for (RemoteResourceInfo fileInfo : client.ls(this.constructRemotePath(template, new String[0]))) {
                client.get(fileInfo.getPath(), (LocalDestFile)target);
            }
            return true;
        }, false);
    }

    @Nullable
    public InputStream zipTemplate(@NonNull ServiceTemplate template) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        return this.executeWithClient((CheckedFunction1 & Serializable)client -> {
            Path localTarget = FileUtil.createTempFile();
            if (this.pull(template, localTarget)) {
                return ZipUtil.zipToStream((Path)localTarget);
            }
            return null;
        }, null);
    }

    public boolean delete(@NonNull ServiceTemplate template) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        return this.executeWithClient((CheckedFunction1 & Serializable)client -> {
            String templatePath = this.constructRemotePath(template, new String[0]);
            FileAttributes attributes = client.statExistence(templatePath);
            if (attributes != null && attributes.getType() == FileMode.Type.DIRECTORY) {
                this.deleteDir((SFTPClient)client, templatePath);
                client.rmdir(templatePath);
                return true;
            }
            return false;
        }, false);
    }

    protected void deleteDir(@NonNull SFTPClient client, @NonNull String dir) throws IOException {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (dir == null) {
            throw new NullPointerException("dir is marked non-null but is null");
        }
        for (RemoteResourceInfo info : client.ls(dir)) {
            if (info.isDirectory()) {
                this.deleteDir(client, info.getPath());
                client.rmdir(info.getPath());
                continue;
            }
            client.rm(info.getPath());
        }
    }

    public boolean create(@NonNull ServiceTemplate template) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        return this.executeWithClient((CheckedFunction1 & Serializable)client -> {
            client.mkdirs(this.constructRemotePath(template, new String[0]));
            return true;
        }, false);
    }

    public boolean contains(@NonNull ServiceTemplate template) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        return this.executeWithClient((CheckedFunction1 & Serializable)client -> {
            FileAttributes attr = client.statExistence(this.constructRemotePath(template, new String[0]));
            return attr != null && attr.getType() == FileMode.Type.DIRECTORY;
        }, false);
    }

    @Nullable
    public OutputStream appendOutputStream(@NonNull ServiceTemplate template, @NonNull String path) throws IOException {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.newOutputStream(template, path, OpenMode.CREAT, OpenMode.WRITE, OpenMode.APPEND);
    }

    @Nullable
    public OutputStream newOutputStream(@NonNull ServiceTemplate st, @NonNull String path) throws IOException {
        if (st == null) {
            throw new NullPointerException("st is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.newOutputStream(st, path, OpenMode.CREAT, OpenMode.WRITE, OpenMode.TRUNC);
    }

    @Nullable
    protected OutputStream newOutputStream(@NonNull ServiceTemplate st, @NonNull String path, OpenMode ... modes) throws IOException {
        RemoteFile file;
        if (st == null) {
            throw new NullPointerException("st is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (modes == null) {
            throw new NullPointerException("modes is marked non-null but is null");
        }
        final SFTPClientPool.SFTPClientWrapper client = this.pool.takeClient();
        RemoteFile remoteFile = file = client.open(this.constructRemotePath(st, path), EnumSet.of(modes[0], modes));
        Objects.requireNonNull(remoteFile);
        return new RemoteFile.RemoteFileOutputStream(remoteFile){

            public void close() throws IOException {
                super.close();
                SFTPTemplateStorage.this.pool.returnClient(client);
            }
        };
    }

    public boolean createFile(@NonNull ServiceTemplate template, @NonNull String path) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.executeWithClient((CheckedFunction1 & Serializable)client -> {
            client.open(this.constructRemotePath(template, path), EnumSet.of(OpenMode.CREAT));
            return true;
        }, false);
    }

    public boolean createDirectory(@NonNull ServiceTemplate template, @NonNull String path) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.executeWithClient((CheckedFunction1 & Serializable)client -> {
            client.mkdirs(this.constructRemotePath(template, path));
            return true;
        }, false);
    }

    public boolean hasFile(@NonNull ServiceTemplate template, @NonNull String path) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.executeWithClient((CheckedFunction1 & Serializable)client -> client.statExistence(this.constructRemotePath(template, path)) != null, false);
    }

    public boolean deleteFile(@NonNull ServiceTemplate template, @NonNull String path) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.executeWithClient((CheckedFunction1 & Serializable)client -> {
            client.rm(this.constructRemotePath(template, path));
            return true;
        }, false);
    }

    @Nullable
    public InputStream newInputStream(@NonNull ServiceTemplate st, @NonNull String path) throws IOException {
        RemoteFile file;
        if (st == null) {
            throw new NullPointerException("st is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        final SFTPClientPool.SFTPClientWrapper client = this.pool.takeClient();
        RemoteFile remoteFile = file = client.open(this.constructRemotePath(st, path), EnumSet.of(OpenMode.CREAT, OpenMode.READ));
        Objects.requireNonNull(remoteFile);
        return new RemoteFile.RemoteFileInputStream(remoteFile){

            public void close() throws IOException {
                super.close();
                SFTPTemplateStorage.this.pool.returnClient(client);
            }
        };
    }

    @Nullable
    public FileInfo fileInfo(@NonNull ServiceTemplate template, @NonNull String path) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return this.executeWithClient((CheckedFunction1 & Serializable)client -> {
            FileAttributes attr = client.statExistence(this.constructRemotePath(template, path));
            return attr == null ? null : this.createFileInfo(attr, path);
        }, null);
    }

    @NonNull
    public Collection<FileInfo> listFiles(@NonNull ServiceTemplate template, @NonNull String dir, boolean deep) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (dir == null) {
            throw new NullPointerException("dir is marked non-null but is null");
        }
        return this.executeWithClient((CheckedFunction1 & Serializable)client -> {
            HashSet<FileInfo> result = new HashSet<FileInfo>();
            this.ls((SFTPClient)client, (Set<FileInfo>)result, template, dir, deep);
            return result;
        }, null);
    }

    protected void ls(@NonNull SFTPClient client, @NonNull Set<FileInfo> result, @NonNull ServiceTemplate template, @NonNull String dir, boolean deep) throws Exception {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (dir == null) {
            throw new NullPointerException("dir is marked non-null but is null");
        }
        for (RemoteResourceInfo info : client.ls(this.constructRemotePath(template, dir))) {
            result.add(this.createFileInfo(info.getAttributes(), info.getPath()));
            if (!info.isDirectory() || !deep) continue;
            this.ls(client, result, template, (String)(dir.endsWith("/") ? dir : dir + "/" + info.getName()), true);
        }
    }

    @NonNull
    public Collection<ServiceTemplate> templates() {
        return this.executeWithClient((CheckedFunction1 & Serializable)client -> {
            HashSet<ServiceTemplate> templates = new HashSet<ServiceTemplate>();
            for (RemoteResourceInfo info : client.ls(this.storageConfig.baseDirectory())) {
                if (!info.isDirectory()) continue;
                for (RemoteResourceInfo template : client.ls(this.storageConfig.baseDirectory() + "/" + info.getName())) {
                    templates.add(ServiceTemplate.builder().prefix(info.getName()).name(template.getName()).storage(this.storageConfig.storage()).build());
                }
            }
            return templates;
        }, Collections.emptySet());
    }

    public void close() throws IOException {
        this.pool.close();
        SSHClient client = this.sshClient;
        if (client != null) {
            client.disconnect();
        }
    }

    @NonNull
    protected String constructRemotePath(@NonNull ServiceTemplate template, String ... parents) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (parents == null) {
            throw new NullPointerException("parents is marked non-null but is null");
        }
        return String.format(REMOTE_DIR_FORMAT, this.storageConfig.baseDirectory(), template.fullName(), String.join((CharSequence)"/", parents));
    }

    @NonNull
    protected FileInfo createFileInfo(@NonNull FileAttributes attributes, @NonNull String path) {
        if (attributes == null) {
            throw new NullPointerException("attributes is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        String[] parts = path.split("/");
        return new FileInfo(path, parts.length == 0 ? path : parts[parts.length - 1], attributes.getType() == FileMode.Type.DIRECTORY, false, attributes.getMtime(), attributes.getMtime(), attributes.getAtime(), attributes.getSize());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T executeWithClient(@NonNull CheckedFunction1<SFTPClient, T> handler, T def) {
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        if (!this.pool.stillActive()) return def;
        try (SFTPClientPool.SFTPClientWrapper client = this.pool.takeClient();){
            Object object = handler.apply((Object)client);
            return (T)object;
        }
        catch (IllegalStateException exception) {
            Throwable throwable3 = exception.getCause();
            if (!(throwable3 instanceof SSHException)) return def;
            SSHException sshException = (SSHException)throwable3;
            LOGGER.severe("Failed to retrieve a new client from the SFTP client pool: %s", null, new Object[]{sshException.getMessage()});
            return def;
        }
        catch (Throwable exception) {
            LOGGER.fine("Exception executing sftp task", exception, new Object[0]);
        }
        return def;
    }
}

