/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.sftp;

import eu.cloudnetservice.common.io.FileUtil;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.document.DocumentFactory;
import eu.cloudnetservice.driver.module.ModuleLifeCycle;
import eu.cloudnetservice.driver.module.ModuleTask;
import eu.cloudnetservice.driver.module.driver.DriverModule;
import eu.cloudnetservice.driver.network.HostAndPort;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import eu.cloudnetservice.driver.template.TemplateStorage;
import eu.cloudnetservice.modules.sftp.SFTPTemplateStorage;
import eu.cloudnetservice.modules.sftp.config.SFTPTemplateStorageConfig;
import eu.cloudnetservice.node.cluster.sync.DataSyncHandler;
import eu.cloudnetservice.node.cluster.sync.DataSyncRegistry;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import lombok.NonNull;

@Singleton
public final class SFTPTemplateStorageModule
extends DriverModule {
    private SFTPTemplateStorage storage;
    private volatile SFTPTemplateStorageConfig config;

    @ModuleTask(order=127, lifecycle=ModuleLifeCycle.LOADED)
    public void convertConfig() {
        Path oldConfigPath = this.moduleWrapper().moduleProvider().moduleDirectoryPath().resolve("CloudNet-Storage-FTP").resolve("config.json");
        if (Files.exists(oldConfigPath, new LinkOption[0])) {
            Document.Mutable config = DocumentFactory.json().parse(oldConfigPath);
            this.updateConfig(new SFTPTemplateStorageConfig((HostAndPort)config.readObject("address", HostAndPort.class), config.getString("storage"), config.getString("username"), config.getString("password"), config.getString("sshKeyPath") == null ? null : Path.of(config.getString("sshKeyPath"), new String[0]), config.getString("sshKeyPassword") == null ? null : config.getString("sshKeyPassword"), null, config.getString("baseDirectory"), 4));
            FileUtil.delete((Path)oldConfigPath.getParent());
        }
    }

    @ModuleTask(lifecycle=ModuleLifeCycle.LOADED)
    public void handleInit(@NonNull ServiceRegistry serviceRegistry, @NonNull DataSyncRegistry dataSyncRegistry) {
        if (serviceRegistry == null) {
            throw new NullPointerException("serviceRegistry is marked non-null but is null");
        }
        if (dataSyncRegistry == null) {
            throw new NullPointerException("dataSyncRegistry is marked non-null but is null");
        }
        this.config = (SFTPTemplateStorageConfig)this.readConfig(SFTPTemplateStorageConfig.class, SFTPTemplateStorageConfig::new, DocumentFactory.json());
        this.storage = new SFTPTemplateStorage(this.config);
        serviceRegistry.registerProvider(TemplateStorage.class, this.storage.name(), (Object)this.storage);
        dataSyncRegistry.registerHandler(DataSyncHandler.builder().key("sftp-storage-config").nameExtractor($ -> "SFTP Template Storage Config").convertObject(SFTPTemplateStorageConfig.class).writer(this::updateConfig).singletonCollector(() -> this.config).currentGetter($ -> this.config).build());
    }

    @ModuleTask(lifecycle=ModuleLifeCycle.STOPPED)
    public void handleStop(@NonNull ServiceRegistry serviceRegistry) throws IOException {
        if (serviceRegistry == null) {
            throw new NullPointerException("serviceRegistry is marked non-null but is null");
        }
        this.storage.close();
        serviceRegistry.unregisterProvider(TemplateStorage.class, this.storage.name());
    }

    public void updateConfig(@NonNull SFTPTemplateStorageConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        this.config = config;
        this.writeConfig((Document)Document.newJsonDocument().appendTree((Object)config));
    }
}

