/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.sftp.config;

import eu.cloudnetservice.driver.network.HostAndPort;
import java.nio.file.Path;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public class SFTPTemplateStorageConfig {
    private final HostAndPort address;
    private final String storage;
    private final String username;
    private final String password;
    private final Path sshKeyPath;
    private final String sshKeyPassword;
    private final Path knownHostFile;
    private final String baseDirectory;
    private final int clientPoolSize;

    public SFTPTemplateStorageConfig() {
        this(new HostAndPort("127.0.0.1", 22), "sftp", "root", "super_secret_key", null, null, null, "/home/cloudnet", 4);
    }

    public SFTPTemplateStorageConfig(@NonNull HostAndPort address, @NonNull String storage, @NonNull String username, @Nullable String password, @Nullable Path sshKeyPath, @Nullable String sshKeyPassword, @Nullable Path knownHostFile, @NonNull String baseDirectory, int clientPoolSize) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (storage == null) {
            throw new NullPointerException("storage is marked non-null but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (baseDirectory == null) {
            throw new NullPointerException("baseDirectory is marked non-null but is null");
        }
        this.address = address;
        this.storage = storage;
        this.username = username;
        this.password = password;
        this.sshKeyPath = sshKeyPath;
        this.sshKeyPassword = sshKeyPassword;
        this.knownHostFile = knownHostFile;
        this.baseDirectory = baseDirectory;
        this.clientPoolSize = clientPoolSize;
    }

    @NonNull
    public HostAndPort address() {
        return this.address;
    }

    @NonNull
    public String storage() {
        return this.storage;
    }

    @NonNull
    public String username() {
        return this.username;
    }

    public @UnknownNullability String password() {
        return this.password;
    }

    public @UnknownNullability Path sshKeyPath() {
        return this.sshKeyPath;
    }

    public @UnknownNullability String sshKeyPassword() {
        return this.sshKeyPassword;
    }

    @Nullable
    public Path knownHostFile() {
        return this.knownHostFile;
    }

    @NonNull
    public String baseDirectory() {
        return this.baseDirectory;
    }

    public int clientPoolSize() {
        return this.clientPoolSize;
    }
}

