/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.modules.sftp.sshj;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalFileFilter;
import org.jetbrains.annotations.Nullable;

public final class FilteringLocalFileSource
extends FileSystemFile {
    private final Path path;
    private final Predicate<Path> filter;

    public FilteringLocalFileSource(@NonNull Path path, @Nullable Predicate<Path> filter) {
        super(path.toFile());
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        this.path = path;
        this.filter = filter;
    }

    public Iterable<FileSystemFile> getChildren(LocalFileFilter filter) throws IOException {
        if (this.filter == null) {
            return super.getChildren(filter);
        }
        return Files.list(this.path).filter(this.filter).map(file -> new FilteringLocalFileSource((Path)file, this.filter)).collect(Collectors.toList());
    }
}

