/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper;

import com.google.common.collect.Lists;
import dev.derklaro.aerogel.Element;
import dev.derklaro.aerogel.binding.BindingBuilder;
import dev.derklaro.aerogel.util.Qualifiers;
import eu.cloudnetservice.driver.inject.InjectionLayer;
import eu.cloudnetservice.wrapper.Premain;
import eu.cloudnetservice.wrapper.Wrapper;
import eu.cloudnetservice.wrapper.transform.ClassTransformerRegistry;
import io.leangen.geantyref.TypeFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main {
    private Main() {
        throw new UnsupportedOperationException();
    }

    public static void main(String ... args) throws Throwable {
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        Instant startInstant = Instant.now();
        InjectionLayer bootInjectLayer = InjectionLayer.boot();
        bootInjectLayer.installAutoConfigureBindings(Main.class.getClassLoader(), "driver");
        bootInjectLayer.installAutoConfigureBindings(Main.class.getClassLoader(), "wrapper");
        Logger rootLogger = LoggerFactory.getLogger((String)"ROOT");
        bootInjectLayer.install(BindingBuilder.create().bind(Element.forType(Logger.class).requireAnnotation((Annotation)Qualifiers.named((String)"root"))).toInstance((Object)rootLogger));
        bootInjectLayer.install(BindingBuilder.create().bind(Element.forType(Instant.class).requireAnnotation((Annotation)Qualifiers.named((String)"startInstant"))).toInstance((Object)startInstant));
        bootInjectLayer.install(BindingBuilder.create().bind(Element.forType(ScheduledExecutorService.class).requireAnnotation((Annotation)Qualifiers.named((String)"taskScheduler"))).toInstance((Object)Executors.newScheduledThreadPool(2)));
        bootInjectLayer.install(BindingBuilder.create().bind(ClassTransformerRegistry.class).toInstance((Object)Premain.transformerRegistry));
        Type type = TypeFactory.parameterizedClass(List.class, (Type[])new Type[]{String.class});
        bootInjectLayer.install(BindingBuilder.create().bind(Element.forType((Type)type).requireAnnotation((Annotation)Qualifiers.named((String)"consoleArgs"))).toInstance((Object)Lists.newArrayList((Object[])args)));
        bootInjectLayer.instance(Wrapper.class);
    }
}

