/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper;

import eu.cloudnetservice.driver.module.ModuleProvider;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.registry.ServiceRegistry;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import lombok.NonNull;

@Singleton
final class ShutdownHandler {
    private final NetworkClient networkClient;
    private final ModuleProvider moduleProvider;
    private final ServiceRegistry serviceRegistry;
    private final ExecutorService scheduledExecutor;

    @Inject
    public ShutdownHandler(@NonNull NetworkClient networkClient, @NonNull ModuleProvider moduleProvider, @NonNull ServiceRegistry serviceRegistry, @Named(value="taskScheduler") @NonNull ScheduledExecutorService scheduledExecutor) {
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        if (moduleProvider == null) {
            throw new NullPointerException("moduleProvider is marked non-null but is null");
        }
        if (serviceRegistry == null) {
            throw new NullPointerException("serviceRegistry is marked non-null but is null");
        }
        if (scheduledExecutor == null) {
            throw new NullPointerException("scheduledExecutor is marked non-null but is null");
        }
        this.networkClient = networkClient;
        this.moduleProvider = moduleProvider;
        this.serviceRegistry = serviceRegistry;
        this.scheduledExecutor = scheduledExecutor;
    }

    public void shutdown() {
        try {
            this.networkClient.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.moduleProvider.unloadAll();
        this.serviceRegistry.unregisterAll();
        this.scheduledExecutor.shutdownNow();
    }
}

