/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper;

import dev.derklaro.aerogel.Order;
import eu.cloudnetservice.common.language.I18n;
import eu.cloudnetservice.driver.event.Event;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.module.DefaultModuleProviderHandler;
import eu.cloudnetservice.driver.module.ModuleProvider;
import eu.cloudnetservice.driver.module.ModuleProviderHandler;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.network.chunk.defaults.ChunkedSessionRegistry;
import eu.cloudnetservice.driver.network.chunk.defaults.factory.EventChunkHandlerFactory;
import eu.cloudnetservice.driver.network.chunk.network.ChunkedPacketListener;
import eu.cloudnetservice.driver.network.protocol.PacketListener;
import eu.cloudnetservice.wrapper.Premain;
import eu.cloudnetservice.wrapper.ShutdownHandler;
import eu.cloudnetservice.wrapper.configuration.WrapperConfiguration;
import eu.cloudnetservice.wrapper.event.ApplicationPostStartEvent;
import eu.cloudnetservice.wrapper.event.ApplicationPreStartEvent;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import eu.cloudnetservice.wrapper.network.chunk.TemplateStorageCallbackListener;
import eu.cloudnetservice.wrapper.network.listener.PacketAuthorizationResponseListener;
import eu.cloudnetservice.wrapper.network.listener.PacketServerChannelMessageListener;
import eu.cloudnetservice.wrapper.network.listener.message.GroupChannelMessageListener;
import eu.cloudnetservice.wrapper.network.listener.message.ServiceChannelMessageListener;
import eu.cloudnetservice.wrapper.network.listener.message.TaskChannelMessageListener;
import eu.cloudnetservice.wrapper.transform.ClassTransformer;
import eu.cloudnetservice.wrapper.transform.ClassTransformerRegistry;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import java.util.jar.JarFile;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Wrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(Wrapper.class);

    @Inject
    @Order(value=100)
    private void initI18n() {
        I18n.loadFromLangPath(Wrapper.class);
        I18n.language((String)System.getProperty("cloudnet.wrapper.messages.language", "en_US"));
    }

    @Inject
    @Order(value=150)
    private void initProviderAndLoadModules(@NonNull ModuleProvider moduleProvider, @NonNull DefaultModuleProviderHandler moduleProviderHandler) {
        if (moduleProvider == null) {
            throw new NullPointerException("moduleProvider is marked non-null but is null");
        }
        if (moduleProviderHandler == null) {
            throw new NullPointerException("moduleProviderHandler is marked non-null but is null");
        }
        moduleProvider.moduleProviderHandler((ModuleProviderHandler)moduleProviderHandler);
        moduleProvider.moduleDirectoryPath(Path.of(".wrapper", "modules"));
        moduleProvider.loadAll().startAll();
    }

    @Inject
    @Order(value=200)
    private void connectToNode(@NonNull EventManager eventManager, @NonNull NetworkClient networkClient, @NonNull WrapperConfiguration configuration, @NonNull ServiceInfoHolder serviceInfoHolder, @NonNull ChunkedSessionRegistry chunkedSessionRegistry) {
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (serviceInfoHolder == null) {
            throw new NullPointerException("serviceInfoHolder is marked non-null but is null");
        }
        if (chunkedSessionRegistry == null) {
            throw new NullPointerException("chunkedSessionRegistry is marked non-null but is null");
        }
        Thread currentThread = Thread.currentThread();
        PacketAuthorizationResponseListener listener = new PacketAuthorizationResponseListener(currentThread);
        networkClient.packetRegistry().addListener(3, (PacketListener)listener);
        ((CompletableFuture)networkClient.connect(configuration.targetListener()).exceptionally(ex -> {
            LOGGER.error("Unable to establish a connection to the target node listener", ex);
            System.exit(-1);
            return null;
        })).join();
        LockSupport.parkNanos(TimeUnit.SECONDS.toNanos(30L));
        if (!listener.wasAuthSuccessful()) {
            throw new IllegalStateException("Unable to authorize wrapper with node");
        }
        serviceInfoHolder.setup();
        networkClient.packetRegistry().removeListeners(3);
        networkClient.packetRegistry().addListener(2, (PacketListener)new ChunkedPacketListener(chunkedSessionRegistry, (Function)new EventChunkHandlerFactory(eventManager)));
        networkClient.packetRegistry().addListener(1, PacketServerChannelMessageListener.class);
    }

    @Inject
    @Order(value=200)
    private void installShutdownHook(@NonNull Provider<ShutdownHandler> shutdownHandlerProvider) {
        if (shutdownHandlerProvider == null) {
            throw new NullPointerException("shutdownHandlerProvider is marked non-null but is null");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            ShutdownHandler shutdownHandler = (ShutdownHandler)shutdownHandlerProvider.get();
            shutdownHandler.shutdown();
        }));
    }

    @Inject
    @Order(value=250)
    private void registerTransformer(@NonNull ClassTransformerRegistry transformerRegistry) {
        if (transformerRegistry == null) {
            throw new NullPointerException("transformerRegistry is marked non-null but is null");
        }
        ServiceLoader<ClassTransformer> serviceLoader = ServiceLoader.load(ClassTransformer.class);
        serviceLoader.stream().map(provider -> {
            try {
                return (ClassTransformer)provider.get();
            }
            catch (ServiceConfigurationError error) {
                String typeName = provider.type().getName();
                LOGGER.debug("Skipping registration of class transformer {} due to spi configuration error", (Object)typeName, (Object)error);
                return null;
            }
        }).filter(Objects::nonNull).forEach(transformerRegistry::registerTransformer);
    }

    @Inject
    @Order(value=300)
    private void registerDefaultListeners(@NonNull EventManager eventManager) {
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        eventManager.registerListener(TaskChannelMessageListener.class);
        eventManager.registerListener(GroupChannelMessageListener.class);
        eventManager.registerListener(ServiceChannelMessageListener.class);
        eventManager.registerListener(TemplateStorageCallbackListener.class);
    }

    @Inject
    @Order(value=0x7FFFFFFF)
    private void startApplication(@NonNull EventManager eventManager, @Named(value="consoleArgs") @NonNull List<String> consoleArgs) throws Exception {
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (consoleArgs == null) {
            throw new NullPointerException("consoleArgs is marked non-null but is null");
        }
        String mainClass = consoleArgs.remove(0);
        String premainClass = consoleArgs.remove(0);
        Path appFile = Path.of(consoleArgs.remove(0), new String[0]);
        boolean preLoadAppJar = Boolean.parseBoolean(consoleArgs.remove(0));
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        if (preLoadAppJar) {
            loader = new URLClassLoader(new URL[]{appFile.toUri().toURL()}, ClassLoader.getSystemClassLoader());
            Premain.preloadClasses(appFile, loader);
        }
        Premain.instrumentation.appendToSystemClassLoaderSearch(new JarFile(appFile.toFile()));
        Premain.invokePremain(premainClass, loader);
        Class<?> main = Class.forName(mainClass, true, loader);
        Method method = main.getMethod("main", String[].class);
        LinkedList<String> arguments = new LinkedList<String>(consoleArgs);
        eventManager.callEvent((Event)new ApplicationPreStartEvent(main, arguments, loader));
        System.setProperty("java.class.path", this.appendAppFileToClassPath(appFile));
        Thread applicationThread = new Thread(() -> {
            try {
                LOGGER.info("Starting application using class {} (pre-main: {})", (Object)mainClass, (Object)premainClass);
                method.invoke(null, new Object[]{arguments.toArray(new String[0])});
            }
            catch (Exception exception) {
                LOGGER.error("Exception while starting application", (Throwable)exception);
            }
        }, "Application-Thread");
        applicationThread.setContextClassLoader(loader);
        applicationThread.start();
        eventManager.callEvent((Event)new ApplicationPostStartEvent(main, applicationThread, loader));
    }

    @NonNull
    private String appendAppFileToClassPath(@NonNull Path appFile) {
        if (appFile == null) {
            throw new NullPointerException("appFile is marked non-null but is null");
        }
        String currentClassPath = System.getProperty("java.class.path");
        if (currentClassPath == null || currentClassPath.isBlank()) {
            return appFile.getFileName().toString();
        }
        return currentClassPath + File.pathSeparator + String.valueOf(appFile.getFileName());
    }
}

