/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper.database;

import eu.cloudnetservice.driver.database.Database;
import eu.cloudnetservice.driver.database.DatabaseProvider;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.rpc.ChainableRPC;
import eu.cloudnetservice.driver.network.rpc.RPC;
import eu.cloudnetservice.driver.network.rpc.RPCSender;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCInvocationTarget;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.network.rpc.factory.RPCImplementationBuilder;
import eu.cloudnetservice.wrapper.database.WrapperDatabase;
import java.util.function.Supplier;
import lombok.NonNull;

public abstract class WrapperDatabaseProvider
implements DatabaseProvider {
    private final RPCSender providerRPCSender;
    private final RPCImplementationBuilder.InstanceAllocator<? extends Database> databaseImplAllocator;

    @RPCInvocationTarget
    public WrapperDatabaseProvider(@NonNull RPCSender sender, @NonNull Supplier<NetworkChannel> channelSupplier) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (channelSupplier == null) {
            throw new NullPointerException("channelSupplier is marked non-null but is null");
        }
        this.providerRPCSender = sender;
        RPCFactory rpcFactory = sender.sourceFactory();
        this.databaseImplAllocator = rpcFactory.newRPCBasedImplementationBuilder(WrapperDatabase.class).superclass(Database.class).targetChannel(channelSupplier).generateImplementation();
    }

    @NonNull
    public Database database(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        RPC baseRPC = this.providerRPCSender.invokeCaller(new Object[]{name});
        return (Database)this.databaseImplAllocator.withBaseRPC((ChainableRPC)baseRPC).withAdditionalConstructorParameters(new Object[]{name}).allocate();
    }
}

