/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper.holder;

import com.google.common.base.Preconditions;
import dev.derklaro.aerogel.auto.Provides;
import eu.cloudnetservice.driver.channel.ChannelMessage;
import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.event.Event;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.service.ProcessSnapshot;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.driver.service.ServiceLifeCycle;
import eu.cloudnetservice.driver.util.VarHandleUtil;
import eu.cloudnetservice.wrapper.configuration.WrapperConfiguration;
import eu.cloudnetservice.wrapper.event.ServiceInfoPropertiesConfigureEvent;
import eu.cloudnetservice.wrapper.event.ServiceInfoSnapshotPublishEvent;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import lombok.NonNull;

@Singleton
@Provides(value={ServiceInfoHolder.class})
public final class WrapperServiceInfoHolder
implements ServiceInfoHolder {
    private static final VarHandle LAST_INFO_VAR_HANDLE;
    private static final VarHandle CURRENT_INFO_VARHANDLE;
    private final EventManager eventManager;
    private final WrapperConfiguration configuration;
    private ServiceInfoSnapshot lastServiceInfoSnapshot;
    private ServiceInfoSnapshot currentServiceInfoSnapshot;

    @Inject
    private WrapperServiceInfoHolder(@NonNull EventManager eventManager, @NonNull WrapperConfiguration configuration) {
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.eventManager = eventManager;
        this.configuration = configuration;
    }

    @Override
    public void setup() {
        ServiceInfoSnapshot suppliedServiceSnapshot;
        Preconditions.checkState((this.currentServiceInfoSnapshot == null ? 1 : 0) != 0, (Object)"Cannot setup twice");
        this.lastServiceInfoSnapshot = suppliedServiceSnapshot = this.configuration.serviceInfoSnapshot();
        this.currentServiceInfoSnapshot = new ServiceInfoSnapshot(System.currentTimeMillis(), suppliedServiceSnapshot.address(), ProcessSnapshot.self(), suppliedServiceSnapshot.configuration(), System.currentTimeMillis(), ServiceLifeCycle.RUNNING, suppliedServiceSnapshot.propertyHolder());
    }

    @Override
    @NonNull
    public ServiceInfoSnapshot serviceInfo() {
        return CURRENT_INFO_VARHANDLE.getAcquire(this);
    }

    @Override
    @NonNull
    public ServiceInfoSnapshot lastServiceInfo() {
        return LAST_INFO_VAR_HANDLE.getAcquire(this);
    }

    @Override
    @NonNull
    public ServiceInfoSnapshot createServiceInfoSnapshot() {
        return this.createServiceInfoSnapshot(this.serviceInfo().propertyHolder());
    }

    @Override
    @NonNull
    public ServiceInfoSnapshot createServiceInfoSnapshot(@NonNull Document properties) {
        if (properties == null) {
            throw new NullPointerException("properties is marked non-null but is null");
        }
        ServiceInfoSnapshot info = this.serviceInfo();
        ServiceInfoPropertiesConfigureEvent event = (ServiceInfoPropertiesConfigureEvent)this.eventManager.callEvent((Event)new ServiceInfoPropertiesConfigureEvent(properties.mutableCopy(), info));
        return new ServiceInfoSnapshot(System.currentTimeMillis(), info.address(), ProcessSnapshot.self(), this.configuration.serviceConfiguration(), info.connectedTime(), ServiceLifeCycle.RUNNING, event.propertyHolder().immutableCopy());
    }

    @Override
    @NonNull
    public ServiceInfoSnapshot configureServiceInfoSnapshot() {
        ServiceInfoSnapshot serviceInfoSnapshot = this.createServiceInfoSnapshot();
        this.configureServiceInfoSnapshot(serviceInfoSnapshot);
        return serviceInfoSnapshot;
    }

    @Override
    public void publishServiceInfoUpdate() {
        this.publishServiceInfoUpdate(this.createServiceInfoSnapshot());
    }

    @Override
    public void publishServiceInfoUpdate(@NonNull ServiceInfoSnapshot serviceInfoSnapshot) {
        if (serviceInfoSnapshot == null) {
            throw new NullPointerException("serviceInfoSnapshot is marked non-null but is null");
        }
        if (this.configuration.serviceConfiguration().serviceId().equals((Object)serviceInfoSnapshot.serviceId())) {
            this.configureServiceInfoSnapshot(serviceInfoSnapshot);
        }
        ChannelMessage.builder().targetAll().message("update_service_info").channel("cloudnet:internal").buffer((DataBuf)DataBuf.empty().writeObject((Object)serviceInfoSnapshot)).build().send();
    }

    private void configureServiceInfoSnapshot(@NonNull ServiceInfoSnapshot serviceInfoSnapshot) {
        if (serviceInfoSnapshot == null) {
            throw new NullPointerException("serviceInfoSnapshot is marked non-null but is null");
        }
        this.eventManager.callEvent((Event)new ServiceInfoSnapshotPublishEvent(serviceInfoSnapshot));
        ServiceInfoSnapshot lastSnapshot = CURRENT_INFO_VARHANDLE.getAndSetRelease(this, serviceInfoSnapshot);
        LAST_INFO_VAR_HANDLE.setRelease(this, lastSnapshot);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        LAST_INFO_VAR_HANDLE = VarHandleUtil.lookup((MethodHandles.Lookup)lookup, WrapperServiceInfoHolder.class, (String)"lastServiceInfoSnapshot", ServiceInfoSnapshot.class);
        CURRENT_INFO_VARHANDLE = VarHandleUtil.lookup((MethodHandles.Lookup)lookup, WrapperServiceInfoHolder.class, (String)"currentServiceInfoSnapshot", ServiceInfoSnapshot.class);
    }
}

