/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper.inject;

import dev.derklaro.aerogel.auto.Factory;
import eu.cloudnetservice.driver.ComponentInfo;
import eu.cloudnetservice.driver.DriverEnvironment;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.network.netty.client.NettyNetworkClient;
import eu.cloudnetservice.driver.service.ServiceId;
import eu.cloudnetservice.wrapper.configuration.WrapperConfiguration;
import eu.cloudnetservice.wrapper.network.NetworkClientChannelHandler;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import lombok.NonNull;

final class BootFactories {
    private BootFactories() {
        throw new UnsupportedOperationException();
    }

    @Factory
    @Singleton
    @NonNull
    public static ComponentInfo provideComponentInfo(@NonNull WrapperConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        ServiceId serviceId = configuration.serviceConfiguration().serviceId();
        return new ComponentInfo(DriverEnvironment.WRAPPER, serviceId.name(), serviceId.nodeUniqueId());
    }

    @Factory
    @Singleton
    @NonNull
    public static NetworkClient provideNetworkClient(@NonNull ComponentInfo componentInfo, @NonNull WrapperConfiguration configuration, @NonNull Provider<NetworkClientChannelHandler> handlerProvider) {
        if (componentInfo == null) {
            throw new NullPointerException("componentInfo is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (handlerProvider == null) {
            throw new NullPointerException("handlerProvider is marked non-null but is null");
        }
        return new NettyNetworkClient(componentInfo, () -> handlerProvider.get(), configuration.sslConfiguration());
    }
}

