/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper.inject;

import dev.derklaro.aerogel.auto.Factory;
import eu.cloudnetservice.driver.ComponentInfo;
import eu.cloudnetservice.driver.database.DatabaseProvider;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.network.NetworkComponent;
import eu.cloudnetservice.driver.network.rpc.defaults.generation.RPCInternalInstanceFactory;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.provider.CloudServiceFactory;
import eu.cloudnetservice.driver.provider.CloudServiceProvider;
import eu.cloudnetservice.driver.provider.ClusterNodeProvider;
import eu.cloudnetservice.driver.provider.GroupConfigurationProvider;
import eu.cloudnetservice.driver.provider.ServiceTaskProvider;
import eu.cloudnetservice.driver.template.TemplateStorageProvider;
import eu.cloudnetservice.wrapper.database.WrapperDatabaseProvider;
import eu.cloudnetservice.wrapper.provider.WrapperTemplateStorageProvider;
import jakarta.inject.Singleton;
import lombok.NonNull;

final class RPCFactories {
    private RPCFactories() {
        throw new UnsupportedOperationException();
    }

    @Factory
    @Singleton
    @NonNull
    public static ClusterNodeProvider provideClusterNodeProvider(@NonNull RPCFactory factory, @NonNull NetworkClient networkClient) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        return (ClusterNodeProvider)factory.newRPCBasedImplementationBuilder(ClusterNodeProvider.class).implementConcreteMethods().targetComponent((NetworkComponent)networkClient).generateImplementation().allocate();
    }

    @Factory
    @Singleton
    @NonNull
    public static ServiceTaskProvider provideServiceTaskProvider(@NonNull RPCFactory factory, @NonNull NetworkClient networkClient) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        return (ServiceTaskProvider)factory.newRPCBasedImplementationBuilder(ServiceTaskProvider.class).implementConcreteMethods().targetComponent((NetworkComponent)networkClient).generateImplementation().allocate();
    }

    @Factory
    @Singleton
    @NonNull
    public static GroupConfigurationProvider provideGroupConfigurationProvider(@NonNull RPCFactory factory, @NonNull NetworkClient networkClient) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        return (GroupConfigurationProvider)factory.newRPCBasedImplementationBuilder(GroupConfigurationProvider.class).implementConcreteMethods().targetComponent((NetworkComponent)networkClient).generateImplementation().allocate();
    }

    @Factory
    @Singleton
    @NonNull
    public static CloudServiceFactory provideCloudServiceFactory(@NonNull RPCFactory factory, @NonNull NetworkClient networkClient) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        return (CloudServiceFactory)factory.newRPCBasedImplementationBuilder(CloudServiceFactory.class).implementConcreteMethods().targetComponent((NetworkComponent)networkClient).generateImplementation().allocate();
    }

    @Factory
    @Singleton
    @NonNull
    public static CloudServiceProvider provideCloudServiceProvider(@NonNull RPCFactory factory, @NonNull NetworkClient networkClient) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        return (CloudServiceProvider)factory.newRPCBasedImplementationBuilder(CloudServiceProvider.class).implementConcreteMethods().targetComponent((NetworkComponent)networkClient).generateImplementation().allocate();
    }

    @Factory
    @Singleton
    @NonNull
    public static TemplateStorageProvider provideTemplateStorageProvider(@NonNull RPCFactory factory, @NonNull NetworkClient networkClient, @NonNull ComponentInfo componentInfo) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        if (componentInfo == null) {
            throw new NullPointerException("componentInfo is marked non-null but is null");
        }
        return (TemplateStorageProvider)factory.newRPCBasedImplementationBuilder(WrapperTemplateStorageProvider.class).superclass(TemplateStorageProvider.class).targetComponent((NetworkComponent)networkClient).generateImplementation().withAdditionalConstructorParameters(new Object[]{RPCInternalInstanceFactory.SpecialArg.RPC_SENDER, componentInfo, networkClient, RPCInternalInstanceFactory.SpecialArg.CHANNEL_SUPPLIER}).allocate();
    }

    @Factory
    @Singleton
    @NonNull
    public static DatabaseProvider provideDatabaseProvider(@NonNull RPCFactory factory, @NonNull NetworkClient networkClient) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        return (DatabaseProvider)factory.newRPCBasedImplementationBuilder(WrapperDatabaseProvider.class).superclass(DatabaseProvider.class).targetComponent((NetworkComponent)networkClient).generateImplementation().withAdditionalConstructorParameters(new Object[]{RPCInternalInstanceFactory.SpecialArg.RPC_SENDER, RPCInternalInstanceFactory.SpecialArg.CHANNEL_SUPPLIER}).allocate();
    }
}

