/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper.network;

import eu.cloudnetservice.driver.event.Event;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.event.events.network.ChannelType;
import eu.cloudnetservice.driver.event.events.network.NetworkChannelCloseEvent;
import eu.cloudnetservice.driver.event.events.network.NetworkChannelInitEvent;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.NetworkChannelHandler;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.def.PacketClientAuthorization;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.wrapper.configuration.WrapperConfiguration;
import jakarta.inject.Inject;
import lombok.NonNull;

public final class NetworkClientChannelHandler
implements NetworkChannelHandler {
    private final EventManager eventManager;
    private final WrapperConfiguration wrapperConfiguration;

    @Inject
    public NetworkClientChannelHandler(@NonNull EventManager eventManager, @NonNull WrapperConfiguration configuration) {
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        this.eventManager = eventManager;
        this.wrapperConfiguration = configuration;
    }

    public void handleChannelInitialize(@NonNull NetworkChannel channel) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        NetworkChannelInitEvent event = (NetworkChannelInitEvent)this.eventManager.callEvent((Event)new NetworkChannelInitEvent(channel, ChannelType.CLIENT_CHANNEL));
        if (event.cancelled()) {
            channel.close();
            return;
        }
        channel.sendPacket((Packet)new PacketClientAuthorization(PacketClientAuthorization.PacketAuthorizationType.WRAPPER_TO_NODE, (DataBuf)DataBuf.empty().writeString(this.wrapperConfiguration.connectionKey()).writeObject((Object)this.wrapperConfiguration.serviceConfiguration().serviceId())));
    }

    public boolean handlePacketReceive(@NonNull NetworkChannel channel, @NonNull Packet packet) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        return true;
    }

    public void handleChannelClose(@NonNull NetworkChannel channel) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        this.eventManager.callEvent((Event)new NetworkChannelCloseEvent(channel, ChannelType.CLIENT_CHANNEL));
    }
}

