/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper.network.listener;

import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.protocol.PacketListener;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import lombok.NonNull;

public final class PacketAuthorizationResponseListener
implements PacketListener {
    private final Thread blockedThread;
    private final AtomicBoolean result;

    public PacketAuthorizationResponseListener(@NonNull Thread blockedThread) {
        if (blockedThread == null) {
            throw new NullPointerException("blockedThread is marked non-null but is null");
        }
        this.blockedThread = blockedThread;
        this.result = new AtomicBoolean(false);
    }

    public void handle(@NonNull NetworkChannel channel, @NonNull Packet packet) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        DataBuf content = packet.content();
        this.result.setRelease(content.readBoolean());
        content.readBoolean();
        content.readBoolean();
        LockSupport.unpark(this.blockedThread);
    }

    public boolean wasAuthSuccessful() {
        return this.result.getAcquire();
    }
}

