/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper.network.listener;

import eu.cloudnetservice.driver.channel.ChannelMessage;
import eu.cloudnetservice.driver.event.Event;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.event.events.channel.ChannelMessageReceiveEvent;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.network.protocol.PacketListener;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

@Singleton
public final class PacketServerChannelMessageListener
implements PacketListener {
    private final EventManager eventManager;

    @Inject
    public PacketServerChannelMessageListener(@NonNull EventManager eventManager) {
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        this.eventManager = eventManager;
    }

    public void handle(@NonNull NetworkChannel channel, @NonNull Packet packet) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        packet.content().readBoolean();
        ChannelMessage message = (ChannelMessage)packet.content().readObject(ChannelMessage.class);
        CompletableFuture response = ((ChannelMessageReceiveEvent)this.eventManager.callEvent((Event)new ChannelMessageReceiveEvent(message, channel, packet.uniqueId() != null))).queryResponse();
        if (packet.uniqueId() != null) {
            if (response != null) {
                response.whenComplete((queryResponse, throwable) -> {
                    if (throwable != null || queryResponse == null) {
                        channel.sendPacket(packet.constructResponse((DataBuf)DataBuf.empty()));
                    } else {
                        channel.sendPacket(packet.constructResponse((DataBuf)DataBuf.empty().writeObject(Set.of(queryResponse))));
                    }
                    message.content().release();
                });
            } else {
                channel.sendPacket(packet.constructResponse((DataBuf)DataBuf.empty()));
                message.content().release();
            }
        } else if (response != null) {
            response.thenAccept(responseMessage -> {
                message.content().release();
                if (responseMessage != null) {
                    responseMessage.content().release();
                }
            });
        } else {
            message.content().release();
        }
    }
}

