/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper.network.listener.message;

import eu.cloudnetservice.driver.event.Event;
import eu.cloudnetservice.driver.event.EventListener;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.event.events.channel.ChannelMessageReceiveEvent;
import eu.cloudnetservice.driver.event.events.group.GroupConfigurationAddEvent;
import eu.cloudnetservice.driver.event.events.group.GroupConfigurationRemoveEvent;
import eu.cloudnetservice.driver.service.GroupConfiguration;
import lombok.NonNull;

public final class GroupChannelMessageListener {
    @EventListener
    public void handle(@NonNull ChannelMessageReceiveEvent event, @NonNull EventManager eventManager) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (event.channel().equals("cloudnet:internal")) {
            switch (event.message()) {
                case "add_group_configuration": {
                    GroupConfiguration configuration = (GroupConfiguration)event.content().readObject(GroupConfiguration.class);
                    eventManager.callEvent((Event)new GroupConfigurationAddEvent(configuration));
                    break;
                }
                case "remove_group_configuration": {
                    GroupConfiguration configuration = (GroupConfiguration)event.content().readObject(GroupConfiguration.class);
                    eventManager.callEvent((Event)new GroupConfigurationRemoveEvent(configuration));
                    break;
                }
            }
        }
    }
}

