/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper.network.listener.message;

import eu.cloudnetservice.driver.document.Document;
import eu.cloudnetservice.driver.event.Event;
import eu.cloudnetservice.driver.event.EventListener;
import eu.cloudnetservice.driver.event.EventManager;
import eu.cloudnetservice.driver.event.events.channel.ChannelMessageReceiveEvent;
import eu.cloudnetservice.driver.event.events.service.CloudServiceDeferredStateEvent;
import eu.cloudnetservice.driver.event.events.service.CloudServiceLifecycleChangeEvent;
import eu.cloudnetservice.driver.event.events.service.CloudServiceLogEntryEvent;
import eu.cloudnetservice.driver.event.events.service.CloudServiceUpdateEvent;
import eu.cloudnetservice.driver.network.buffer.DataBuf;
import eu.cloudnetservice.driver.service.ServiceCreateResult;
import eu.cloudnetservice.driver.service.ServiceInfoSnapshot;
import eu.cloudnetservice.driver.service.ServiceLifeCycle;
import eu.cloudnetservice.wrapper.holder.ServiceInfoHolder;
import java.util.UUID;
import lombok.NonNull;

public final class ServiceChannelMessageListener {
    @EventListener
    public void handleChannelMessage(@NonNull ChannelMessageReceiveEvent event, @NonNull EventManager eventManager, @NonNull ServiceInfoHolder serviceInfoHolder) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (eventManager == null) {
            throw new NullPointerException("eventManager is marked non-null but is null");
        }
        if (serviceInfoHolder == null) {
            throw new NullPointerException("serviceInfoHolder is marked non-null but is null");
        }
        if (event.channel().equals("cloudnet:internal")) {
            switch (event.message()) {
                case "update_service_info": {
                    ServiceInfoSnapshot snapshot = (ServiceInfoSnapshot)event.content().readObject(ServiceInfoSnapshot.class);
                    eventManager.callEvent((Event)new CloudServiceUpdateEvent(snapshot));
                    break;
                }
                case "update_service_lifecycle": {
                    ServiceLifeCycle lifeCycle = (ServiceLifeCycle)event.content().readObject(ServiceLifeCycle.class);
                    ServiceInfoSnapshot snapshot = (ServiceInfoSnapshot)event.content().readObject(ServiceInfoSnapshot.class);
                    eventManager.callEvent((Event)new CloudServiceLifecycleChangeEvent(lifeCycle, snapshot));
                    break;
                }
                case "request_update_service_information": {
                    event.binaryResponse((DataBuf)DataBuf.empty().writeObject((Object)serviceInfoHolder.configureServiceInfoSnapshot()));
                    break;
                }
                case "request_update_service_information_with_new_properties": {
                    Document properties = (Document)event.content().readObject(Document.class);
                    ServiceInfoSnapshot snapshot = serviceInfoHolder.createServiceInfoSnapshot(properties);
                    serviceInfoHolder.publishServiceInfoUpdate(snapshot);
                    break;
                }
                case "screen_new_line": {
                    ServiceInfoSnapshot snapshot = (ServiceInfoSnapshot)event.content().readObject(ServiceInfoSnapshot.class);
                    String eventChannel = event.content().readString();
                    String line = event.content().readString();
                    CloudServiceLogEntryEvent.StreamType type = event.content().readBoolean() ? CloudServiceLogEntryEvent.StreamType.STDERR : CloudServiceLogEntryEvent.StreamType.STDOUT;
                    eventManager.callEvent(eventChannel, (Event)new CloudServiceLogEntryEvent(snapshot, line, type));
                    break;
                }
                case "deferred_service_event": {
                    UUID creationId = event.content().readUniqueId();
                    ServiceCreateResult createResult = (ServiceCreateResult)event.content().readObject(ServiceCreateResult.class);
                    eventManager.callEvent((Event)new CloudServiceDeferredStateEvent(creationId, createResult));
                    break;
                }
            }
        }
    }
}

