/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper.provider;

import dev.derklaro.aerogel.auto.Provides;
import eu.cloudnetservice.driver.channel.ChannelMessage;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.network.def.PacketServerChannelMessage;
import eu.cloudnetservice.driver.network.protocol.Packet;
import eu.cloudnetservice.driver.provider.CloudMessenger;
import eu.cloudnetservice.driver.provider.defaults.DefaultMessenger;
import io.leangen.geantyref.TypeFactory;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;

@Singleton
@Provides(value={CloudMessenger.class})
public class WrapperMessenger
extends DefaultMessenger
implements CloudMessenger {
    private static final Type MESSAGES = TypeFactory.parameterizedClass(Collection.class, (Type[])new Type[]{ChannelMessage.class});
    private final NetworkClient networkClient;

    @Inject
    public WrapperMessenger(@NonNull NetworkClient networkClient) {
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        this.networkClient = networkClient;
    }

    public void sendChannelMessage(@NonNull ChannelMessage channelMessage) {
        if (channelMessage == null) {
            throw new NullPointerException("channelMessage is marked non-null but is null");
        }
        if (channelMessage.sendSync()) {
            this.networkClient.sendPacketSync((Packet)new PacketServerChannelMessage(channelMessage, true));
        } else {
            this.networkClient.sendPacket((Packet)new PacketServerChannelMessage(channelMessage, true));
        }
    }

    @NonNull
    public Collection<ChannelMessage> sendChannelMessageQuery(@NonNull ChannelMessage channelMessage) {
        if (channelMessage == null) {
            throw new NullPointerException("channelMessage is marked non-null but is null");
        }
        Collection response = (Collection)((Packet)this.networkClient.firstChannel().sendQueryAsync((Packet)new PacketServerChannelMessage(channelMessage, true)).join()).content().readObject(MESSAGES);
        return Objects.requireNonNullElse(response, List.of());
    }
}

