/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper.provider;

import eu.cloudnetservice.driver.ComponentInfo;
import eu.cloudnetservice.driver.network.NetworkChannel;
import eu.cloudnetservice.driver.network.NetworkClient;
import eu.cloudnetservice.driver.network.rpc.ChainableRPC;
import eu.cloudnetservice.driver.network.rpc.RPC;
import eu.cloudnetservice.driver.network.rpc.RPCSender;
import eu.cloudnetservice.driver.network.rpc.annotation.RPCInvocationTarget;
import eu.cloudnetservice.driver.network.rpc.factory.RPCFactory;
import eu.cloudnetservice.driver.network.rpc.factory.RPCImplementationBuilder;
import eu.cloudnetservice.driver.template.TemplateStorage;
import eu.cloudnetservice.driver.template.TemplateStorageProvider;
import eu.cloudnetservice.driver.template.defaults.RemoteTemplateStorage;
import java.util.function.Supplier;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public abstract class WrapperTemplateStorageProvider
implements TemplateStorageProvider {
    private final RPCSender providerRPCSender;
    private final RPCImplementationBuilder.InstanceAllocator<? extends TemplateStorage> templateStorageAllocator;

    @RPCInvocationTarget
    public WrapperTemplateStorageProvider(@NonNull RPCSender sender, @NonNull ComponentInfo componentInfo, @NonNull NetworkClient networkClient, @NonNull Supplier<NetworkChannel> channelSupplier) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        if (componentInfo == null) {
            throw new NullPointerException("componentInfo is marked non-null but is null");
        }
        if (networkClient == null) {
            throw new NullPointerException("networkClient is marked non-null but is null");
        }
        if (channelSupplier == null) {
            throw new NullPointerException("channelSupplier is marked non-null but is null");
        }
        this.providerRPCSender = sender;
        RPCFactory rpcFactory = sender.sourceFactory();
        this.templateStorageAllocator = rpcFactory.newRPCBasedImplementationBuilder(RemoteTemplateStorage.class).superclass(TemplateStorage.class).targetChannel(channelSupplier).generateImplementation().withAdditionalConstructorParameters(new Object[]{null, componentInfo, networkClient});
    }

    @NonNull
    public TemplateStorage localTemplateStorage() {
        TemplateStorage storage = this.templateStorage("local");
        if (storage != null) {
            return storage;
        }
        throw new UnsupportedOperationException("The local storage was unregistered!");
    }

    @Nullable
    public TemplateStorage templateStorage(@NonNull String storage) {
        if (storage == null) {
            throw new NullPointerException("storage is marked non-null but is null");
        }
        RPC baseRPC = this.providerRPCSender.invokeCaller(new Object[]{storage});
        return (TemplateStorage)this.templateStorageAllocator.withBaseRPC((ChainableRPC)baseRPC).changeConstructorParameter(0, (Object)storage).allocate();
    }
}

