/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper.transform;

import eu.cloudnetservice.wrapper.transform.ClassTransformer;
import eu.cloudnetservice.wrapper.transform.ClassTransformerRegistry;
import jakarta.inject.Singleton;
import java.lang.classfile.ClassFile;
import java.lang.classfile.ClassModel;
import java.lang.classfile.ClassTransform;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class DefaultClassTransformerRegistry
implements ClassTransformerRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClassTransformerRegistry.class);
    private final Instrumentation instrumentation;

    public DefaultClassTransformerRegistry(@NonNull Instrumentation instrumentation) {
        if (instrumentation == null) {
            throw new NullPointerException("instrumentation is marked non-null but is null");
        }
        this.instrumentation = instrumentation;
    }

    @Override
    public void registerTransformer(@NonNull ClassTransformer transformer) {
        if (transformer == null) {
            throw new NullPointerException("transformer is marked non-null but is null");
        }
        RegisteredClassTransformer transformerToRegister = new RegisteredClassTransformer(transformer, this.instrumentation);
        this.instrumentation.addTransformer(transformerToRegister, false);
    }

    private record RegisteredClassTransformer(@NonNull ClassTransformer transformer, @NonNull Instrumentation instrumentation) implements ClassFileTransformer
    {
        @Generated
        public RegisteredClassTransformer(@NonNull ClassTransformer transformer, @NonNull Instrumentation instrumentation) {
            if (transformer == null) {
                throw new NullPointerException("transformer is marked non-null but is null");
            }
            if (instrumentation == null) {
                throw new NullPointerException("instrumentation is marked non-null but is null");
            }
        }

        @Override
        public byte[] transform(@Nullable ClassLoader loader, @NonNull String className, @Nullable Class<?> classBeingRedefined, @Nullable ProtectionDomain protectionDomain, byte[] classfileBuffer) {
            if (className == null) {
                throw new NullPointerException("className is marked non-null but is null");
            }
            if (classBeingRedefined != null) {
                return null;
            }
            ClassTransformer.TransformWillingness transformWillingness = this.transformer.classTransformWillingness(className);
            if (transformWillingness == ClassTransformer.TransformWillingness.REJECT) {
                return null;
            }
            if (transformWillingness == ClassTransformer.TransformWillingness.ACCEPT_ONCE) {
                this.instrumentation.removeTransformer(this);
            }
            String transformerClassName = this.transformer.getClass().getName();
            LOGGER.debug("Transforming class {} using transformer {}", (Object)className, (Object)transformerClassName);
            try {
                ClassFile classFile = ClassFile.of();
                ClassModel classModel = classFile.parse(classfileBuffer);
                ClassTransform classTransform = this.transformer.provideClassTransform();
                return classFile.transform(classModel, classTransform);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to transform class {} using transformer {}", new Object[]{className, transformerClassName, exception});
                return null;
            }
        }
    }
}

