/*
 * Decompiled with CFR 0.152.
 */
package eu.cloudnetservice.wrapper.transform.bukkit;

import eu.cloudnetservice.wrapper.transform.ClassTransformer;
import java.lang.classfile.ClassTransform;
import java.lang.classfile.CodeBuilder;
import java.lang.classfile.CodeElement;
import java.lang.classfile.CodeModel;
import java.lang.classfile.CodeTransform;
import java.lang.classfile.MethodModel;
import java.lang.reflect.AccessFlag;
import java.util.ArrayDeque;
import java.util.Deque;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class BukkitCommodoreTransformer
implements ClassTransformer {
    private static final String MN_CONVERT = "convert";
    private static final String CN_COMMODORE = "Commodore";
    private static final String PNI_COMMODORE = "org/bukkit/craftbukkit/";

    @Override
    @NonNull
    public ClassTransform provideClassTransform() {
        CodeTransform codeTransform = CodeTransform.ofStateful(ConvertMethodTryCatchWrapperCodeTransform::new);
        return ClassTransform.transformingMethodBodies(mm -> {
            String descriptorString = mm.methodType().stringValue();
            return descriptorString.startsWith("([B") && mm.methodName().equalsString(MN_CONVERT);
        }, (CodeTransform)codeTransform);
    }

    @Override
    @NonNull
    public ClassTransformer.TransformWillingness classTransformWillingness(@NonNull String internalClassName) {
        if (internalClassName == null) {
            throw new NullPointerException("internalClassName is marked non-null but is null");
        }
        boolean isCommodore = internalClassName.startsWith(PNI_COMMODORE) && internalClassName.endsWith(CN_COMMODORE);
        return isCommodore ? ClassTransformer.TransformWillingness.ACCEPT_ONCE : ClassTransformer.TransformWillingness.REJECT;
    }

    private static final class ConvertMethodTryCatchWrapperCodeTransform
    implements CodeTransform {
        private final Deque<CodeElement> methodElements = new ArrayDeque<CodeElement>();

        private ConvertMethodTryCatchWrapperCodeTransform() {
        }

        public void accept(@NonNull CodeBuilder builder, @NonNull CodeElement element) {
            if (builder == null) {
                throw new NullPointerException("builder is marked non-null but is null");
            }
            if (element == null) {
                throw new NullPointerException("element is marked non-null but is null");
            }
            this.methodElements.add(element);
        }

        public void atEnd(@NonNull CodeBuilder builder) {
            if (builder == null) {
                throw new NullPointerException("builder is marked non-null but is null");
            }
            MethodModel methodModel = (MethodModel)builder.original().flatMap(CodeModel::parent).orElseThrow(() -> new IllegalStateException("original method not preset on remap"));
            boolean transformMethodIsStatic = methodModel.flags().has(AccessFlag.STATIC);
            builder.trying(this.methodElements::forEach, catchBuilder -> catchBuilder.catchingAll(blockCodeBuilder -> {})).aload(transformMethodIsStatic ? 0 : 1).areturn();
        }
    }
}

